/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.zookeeper.impl.ZKAsyncMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncMapTTLMonitor<K, V> {
    private final Vertx vertx;
    private final ClusterManager clusterManager;
    private final Map<String, ZKAsyncMap<K, V>> keyPathAndAsyncMap = new ConcurrentHashMap<String, ZKAsyncMap<K, V>>();
    static final String TTL_KEY_HANDLER_ADDRESS = "__VERTX_ZK_TTL_HANDLER_ADDRESS";
    static final String TTL_KEY_BODY_KEY_PATH = "keyPath";
    static final String TTL_KEY_BODY_TIMEOUT = "timeout";
    static final String TTL_KEY_IS_CANCEL = "isCancel";
    private static final String TTL_KEY_LOCK = "__VERTX_ZK_TTL_LOCK";
    private static final long TTL_KEY_GET_LOCK_TIMEOUT = 1500L;
    private final LocalMap<String, Long> ttlTimer;
    private MessageConsumer<JsonObject> consumer;
    private static volatile AsyncMapTTLMonitor instance;
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <K, V> AsyncMapTTLMonitor<K, V> getInstance(Vertx vertx, ClusterManager clusterManager) {
        if (instance != null) return instance;
        Class<AsyncMapTTLMonitor> clazz = AsyncMapTTLMonitor.class;
        synchronized (AsyncMapTTLMonitor.class) {
            if (instance != null) return instance;
            instance = new AsyncMapTTLMonitor<K, V>(vertx, clusterManager);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private AsyncMapTTLMonitor(Vertx vertx, ClusterManager clusterManager) {
        this.ttlTimer = vertx.sharedData().getLocalMap("__VERTX_ZK_TTL_TIMER");
        this.vertx = vertx;
        this.clusterManager = clusterManager;
        this.initConsumer();
    }

    private void initConsumer() {
        this.consumer = this.vertx.eventBus().consumer(TTL_KEY_HANDLER_ADDRESS, event -> {
            JsonObject body = (JsonObject)event.body();
            String keyPath = body.getString(TTL_KEY_BODY_KEY_PATH);
            if (this.keyPathAndAsyncMap.get(keyPath) == null) {
                return;
            }
            if (body.getBoolean(TTL_KEY_IS_CANCEL, Boolean.valueOf(false)).booleanValue()) {
                long timerID = (Long)this.ttlTimer.remove((Object)body.getString(keyPath));
                if (timerID > 0L) {
                    this.vertx.cancelTimer(timerID);
                }
            } else {
                long timerID = this.vertx.setTimer(body.getLong(TTL_KEY_BODY_TIMEOUT).longValue(), aLong -> this.clusterManager.getLockWithTimeout(TTL_KEY_LOCK, 1500L, lockAsyncResult -> {
                    ZKAsyncMap zkAsyncMap = this.keyPathAndAsyncMap.get(keyPath);
                    if (lockAsyncResult.succeeded()) {
                        zkAsyncMap.checkExists(keyPath).compose(checkResult -> checkResult != false ? zkAsyncMap.delete(keyPath, (Object)null) : Future.succeededFuture()).setHandler(deleteResult -> {
                            if (deleteResult.succeeded()) {
                                ((Lock)lockAsyncResult.result()).release();
                                logger.debug((Object)String.format("The key %s have arrived time, and have been deleted.", keyPath));
                            } else {
                                logger.error((Object)String.format("Delete expire key %s failed.", keyPath), deleteResult.cause());
                            }
                        });
                    } else {
                        logger.error((Object)"get TTL lock failed.", lockAsyncResult.cause());
                    }
                }));
                this.ttlTimer.put((Object)keyPath, (Object)timerID);
            }
        });
    }

    void addAsyncMapWithPath(String keyPath, ZKAsyncMap<K, V> asyncMap) {
        this.keyPathAndAsyncMap.putIfAbsent(keyPath, asyncMap);
    }

    public void stop() {
        this.consumer.unregister();
        this.keyPathAndAsyncMap.clear();
        instance = null;
    }

    static {
        logger = LoggerFactory.getLogger(AsyncMapTTLMonitor.class);
    }
}

