/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.VertxException;
import io.vertx.spi.cluster.zookeeper.impl.ZKMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ZKSyncMap<K, V>
extends ZKMap<K, V>
implements Map<K, V> {
    public ZKSyncMap(CuratorFramework curator, String mapName) {
        super(curator, null, "syncMap", mapName);
    }

    @Override
    public int size() {
        try {
            return ((List)this.curator.getChildren().forPath(this.mapPath)).size();
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return ((List)this.curator.getChildren().forPath(this.mapPath)).isEmpty();
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.curator.checkExists().forPath(this.keyPath(key)) != null;
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return ((List)this.curator.getChildren().forPath(this.mapPath)).stream().anyMatch(k -> {
                try {
                    byte[] bytes = (byte[])this.curator.getData().forPath(this.keyPath(k));
                    KeyValue keyValue = (KeyValue)this.asObject(bytes);
                    return keyValue.getValue().equals(value);
                }
                catch (Exception ex) {
                    throw new VertxException((Throwable)ex);
                }
            });
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public V get(Object key) {
        try {
            String keyPath = this.keyPath(key);
            if (null == this.curator.checkExists().forPath(keyPath)) {
                return null;
            }
            KeyValue keyValue = (KeyValue)this.asObject((byte[])this.curator.getData().forPath(keyPath));
            return keyValue.getValue();
        }
        catch (Exception e) {
            if (!(e instanceof KeeperException.NodeExistsException)) {
                throw new VertxException((Throwable)e);
            }
            return null;
        }
    }

    @Override
    public V put(K key, V value) {
        try {
            String keyPath = this.keyPath(key);
            KeyValue<K, V> keyValue = new KeyValue<K, V>(key, value);
            byte[] valueBytes = this.asByte(keyValue);
            if (this.get(key) != null) {
                this.curator.setData().forPath(keyPath, valueBytes);
            } else {
                ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(keyPath, valueBytes);
            }
            return value;
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public V remove(Object key) {
        try {
            V result = this.get(key);
            if (result != null) {
                this.curator.delete().deletingChildrenIfNeeded().forPath(this.keyPath(key));
            }
            return result;
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.entrySet().stream().forEach((? super T entry) -> this.put(entry.getKey(), entry.getValue()));
    }

    @Override
    public void clear() {
        try {
            this.curator.delete().deletingChildrenIfNeeded().forPath(this.mapPath);
            this.curator.create().creatingParentsIfNeeded().forPath(this.mapPath);
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public Set<K> keySet() {
        try {
            return ((List)this.curator.getChildren().forPath(this.mapPath)).stream().map(k -> {
                try {
                    KeyValue keyValue = (KeyValue)this.asObject((byte[])this.curator.getData().forPath(this.keyPath(k)));
                    return keyValue.getKey();
                }
                catch (Exception ex) {
                    throw new VertxException((Throwable)ex);
                }
            }).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            throw new VertxException((Throwable)ex);
        }
    }

    @Override
    public Collection<V> values() {
        try {
            return ((List)this.curator.getChildren().forPath(this.mapPath)).stream().map(k -> {
                try {
                    KeyValue keyValue = (KeyValue)this.asObject((byte[])this.curator.getData().forPath(this.keyPath(k)));
                    return keyValue.getValue();
                }
                catch (Exception ex) {
                    throw new VertxException((Throwable)ex);
                }
            }).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            throw new VertxException((Throwable)ex);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.keySet().stream().map(k -> {
            V v = this.get(k);
            return new AbstractMap.SimpleImmutableEntry<Object, V>(k, v);
        }).collect(Collectors.toSet());
    }

    static class KeyValue<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6529685098267757690L;
        private K key;
        private V value;

        public KeyValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

