/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.zookeeper.MockZKCluster;
import io.vertx.spi.cluster.zookeeper.ZookeeperClusterManager;
import io.vertx.test.core.AsyncTestBase;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.junit.Test;

public class ProgrammaticZKClusterManagerTest
extends AsyncTestBase {
    private MockZKCluster zkCluster = new MockZKCluster();
    private RetryPolicy retryPolicy = new ExponentialBackoffRetry(2000, 5, 10000);

    private void testProgrammatic(ZookeeperClusterManager mgr, JsonObject config) throws Exception {
        mgr.setConfig(config);
        this.assertEquals(config, mgr.getConfig());
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)mgr);
        Vertx.clusteredVertx((VertxOptions)options, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr.getCuratorFramework());
            ((Vertx)res.result()).close(res2 -> {
                this.assertTrue(res2.succeeded());
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testProgrammaticSetConfig() throws Exception {
        JsonObject config = this.zkCluster.getDefaultConfig();
        ZookeeperClusterManager mgr = new ZookeeperClusterManager();
        mgr.setConfig(config);
        this.testProgrammatic(mgr, config);
    }

    @Test
    public void testProgrammaticSetWithConstructor() throws Exception {
        JsonObject config = this.zkCluster.getDefaultConfig();
        ZookeeperClusterManager mgr = new ZookeeperClusterManager(config);
        this.testProgrammatic(mgr, config);
    }

    @Test
    public void testCustomCuratorFramework() throws Exception {
        JsonObject config = this.zkCluster.getDefaultConfig();
        CuratorFramework curator = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        curator.start();
        ZookeeperClusterManager mgr = new ZookeeperClusterManager(curator);
        this.testProgrammatic(mgr, config);
    }

    @Test
    public void testEventBusWhenUsingACustomCurator() throws Exception {
        JsonObject config = this.zkCluster.getDefaultConfig();
        CuratorFramework curator1 = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        curator1.start();
        CuratorFramework curator2 = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        curator2.start();
        ZookeeperClusterManager mgr1 = new ZookeeperClusterManager(curator1);
        ZookeeperClusterManager mgr2 = new ZookeeperClusterManager(curator2);
        VertxOptions options1 = new VertxOptions().setClusterManager((ClusterManager)mgr1);
        VertxOptions options2 = new VertxOptions().setClusterManager((ClusterManager)mgr2);
        AtomicReference vertx1 = new AtomicReference();
        AtomicReference vertx2 = new AtomicReference();
        Vertx.clusteredVertx((VertxOptions)options1, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr1.getCuratorFramework());
            ((Vertx)res.result()).eventBus().consumer("news", message -> {
                this.assertNotNull(message);
                this.assertTrue(message.body().equals("hello"));
                message.reply((Object)"hi");
            });
            vertx1.set(res.result());
        });
        ProgrammaticZKClusterManagerTest.assertWaitUntil(() -> vertx1.get() != null);
        Vertx.clusteredVertx((VertxOptions)options2, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr2.getCuratorFramework());
            vertx2.set(res.result());
            ((Vertx)res.result()).eventBus().request("news", (Object)"hello", ar -> {
                this.assertTrue(ar.succeeded());
                this.testComplete();
            });
        });
        this.await();
        ((Vertx)vertx1.get()).close(ar -> vertx1.set(null));
        ((Vertx)vertx2.get()).close(ar -> vertx2.set(null));
        this.assertTrue(curator1.getState() == CuratorFrameworkState.STARTED);
        this.assertTrue(curator2.getState() == CuratorFrameworkState.STARTED);
        ProgrammaticZKClusterManagerTest.assertWaitUntil(() -> vertx1.get() == null && vertx2.get() == null);
        curator1.close();
        curator2.close();
    }

    @Test
    public void testSharedDataUsingCustomCurator() throws Exception {
        JsonObject config = this.zkCluster.getDefaultConfig();
        CuratorFramework curator1 = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        curator1.start();
        CuratorFramework curator2 = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        curator2.start();
        ZookeeperClusterManager mgr1 = new ZookeeperClusterManager(curator1);
        ZookeeperClusterManager mgr2 = new ZookeeperClusterManager(curator2);
        VertxOptions options1 = new VertxOptions().setClusterManager((ClusterManager)mgr1);
        options1.getEventBusOptions().setHost("127.0.0.1");
        VertxOptions options2 = new VertxOptions().setClusterManager((ClusterManager)mgr2);
        options2.getEventBusOptions().setHost("127.0.0.1");
        AtomicReference vertx1 = new AtomicReference();
        AtomicReference vertx2 = new AtomicReference();
        Vertx.clusteredVertx((VertxOptions)options1, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr1.getCuratorFramework());
            ((Vertx)res.result()).sharedData().getClusterWideMap("mymap1", ar -> ((AsyncMap)ar.result()).put((Object)"news", (Object)"hello", v -> vertx1.set(res.result())));
        });
        ProgrammaticZKClusterManagerTest.assertWaitUntil(() -> vertx1.get() != null);
        Vertx.clusteredVertx((VertxOptions)options2, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr2.getCuratorFramework());
            vertx2.set(res.result());
            ((Vertx)res.result()).sharedData().getClusterWideMap("mymap1", ar -> ((AsyncMap)ar.result()).get((Object)"news", r -> {
                this.assertEquals("hello", r.result());
                this.testComplete();
            }));
        });
        this.await();
        ((Vertx)vertx1.get()).close(ar -> vertx1.set(null));
        ((Vertx)vertx2.get()).close(ar -> vertx2.set(null));
        ProgrammaticZKClusterManagerTest.assertWaitUntil(() -> vertx1.get() == null && vertx2.get() == null);
        this.assertTrue(curator1.getState() == CuratorFrameworkState.STOPPED);
        this.assertTrue(curator2.getState() == CuratorFrameworkState.STOPPED);
        curator1.close();
        curator2.close();
    }

    @Test
    public void testThatExternalCuratorCanBeShutdown() {
        JsonObject config = this.zkCluster.getDefaultConfig();
        CuratorFramework curator = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        curator.start();
        String nodeID = UUID.randomUUID().toString();
        ZookeeperClusterManager mgr = new ZookeeperClusterManager(curator, nodeID);
        VertxOptions options = new VertxOptions().setClusterManager((ClusterManager)mgr);
        options.getEventBusOptions().setHost("127.0.0.1");
        AtomicReference vertx1 = new AtomicReference();
        Vertx.clusteredVertx((VertxOptions)options, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr.getCuratorFramework());
            ((Vertx)res.result()).sharedData().getClusterWideMap("mymap1", ar -> ((AsyncMap)ar.result()).put((Object)"news", (Object)"hello", v -> vertx1.set(res.result())));
        });
        ProgrammaticZKClusterManagerTest.assertWaitUntil(() -> vertx1.get() != null);
        int size = mgr.getNodes().size();
        this.assertTrue(size > 0);
        this.assertTrue(mgr.getNodes().contains(nodeID));
        try {
            byte[] content = (byte[])curator.getData().forPath("/asyncMap/mymap1/news");
            String result = new String(Arrays.copyOfRange(content, 8, 13));
            this.assertEquals("hello", result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        curator.close();
        ProgrammaticZKClusterManagerTest.assertWaitUntil(() -> mgr.getNodes().size() == size - 1);
        ((Vertx)vertx1.get()).close();
        ((Vertx)vertx1.get()).close(ar -> vertx1.set(null));
        ProgrammaticZKClusterManagerTest.assertWaitUntil(() -> vertx1.get() == null);
    }

    @Test
    public void testSharedDataUsingCustomCuratorFrameworks() throws Exception {
        JsonObject config = this.zkCluster.getDefaultConfig();
        CuratorFramework dataNode1 = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        dataNode1.start();
        CuratorFramework dataNode2 = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        dataNode2.start();
        CuratorFramework curator1 = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        curator1.start();
        CuratorFramework curator2 = CuratorFrameworkFactory.builder().connectString(config.getString("zookeeperHosts")).namespace(config.getString("rootPath")).retryPolicy(this.retryPolicy).build();
        curator2.start();
        ZookeeperClusterManager mgr1 = new ZookeeperClusterManager(curator1);
        ZookeeperClusterManager mgr2 = new ZookeeperClusterManager(curator2);
        VertxOptions options1 = new VertxOptions().setClusterManager((ClusterManager)mgr1);
        options1.getEventBusOptions().setHost("127.0.0.1");
        VertxOptions options2 = new VertxOptions().setClusterManager((ClusterManager)mgr2);
        options2.getEventBusOptions().setHost("127.0.0.1");
        AtomicReference vertx1 = new AtomicReference();
        AtomicReference vertx2 = new AtomicReference();
        Vertx.clusteredVertx((VertxOptions)options1, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr1.getCuratorFramework());
            ((Vertx)res.result()).sharedData().getClusterWideMap("mymap1", ar -> ((AsyncMap)ar.result()).put((Object)"news", (Object)"hello", v -> vertx1.set(res.result())));
        });
        ProgrammaticZKClusterManagerTest.assertWaitUntil(() -> vertx1.get() != null);
        Vertx.clusteredVertx((VertxOptions)options2, res -> {
            this.assertTrue(res.succeeded());
            this.assertNotNull(mgr2.getCuratorFramework());
            vertx2.set(res.result());
            ((Vertx)res.result()).sharedData().getClusterWideMap("mymap1", ar -> ((AsyncMap)ar.result()).get((Object)"news", r -> {
                this.assertEquals("hello", r.result());
                this.testComplete();
            }));
        });
        this.await();
        ((Vertx)vertx1.get()).close(ar -> vertx1.set(null));
        ((Vertx)vertx2.get()).close(ar -> vertx2.set(null));
        ProgrammaticZKClusterManagerTest.assertWaitUntil(() -> vertx1.get() == null && vertx2.get() == null);
        this.assertTrue(curator1.getState() == CuratorFrameworkState.STOPPED);
        this.assertTrue(curator2.getState() == CuratorFrameworkState.STOPPED);
        curator1.close();
        curator2.close();
        this.assertTrue(dataNode1.getState() == CuratorFrameworkState.STARTED);
        this.assertTrue(dataNode2.getState() == CuratorFrameworkState.STARTED);
        dataNode1.close();
        dataNode2.close();
    }
}

