/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.ClusteredEventBusTest;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.zookeeper.MockZKCluster;
import io.vertx.test.core.TestUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Test;

public class ZKClusteredEventbusTest
extends ClusteredEventBusTest {
    private final MockZKCluster zkClustered = new MockZKCluster();

    public void tearDown() throws Exception {
        super.tearDown();
        this.zkClustered.stop();
    }

    public void await(long delay, TimeUnit timeUnit) {
        super.await(10L, TimeUnit.SECONDS);
    }

    protected <T, R> void testSend(T val, R received, Consumer<T> consumer, DeliveryOptions options) {
        if (this.vertices == null) {
            this.startNodes(2);
        }
        MessageConsumer reg = this.vertices[1].eventBus().consumer("some-address1").handler(msg -> {
            if (consumer == null) {
                this.assertTrue(msg.isSend());
                this.assertEquals(received, msg.body());
                if (options != null) {
                    this.assertNotNull(msg.headers());
                    int numHeaders = options.getHeaders() != null ? options.getHeaders().size() : 0;
                    this.assertEquals(numHeaders, msg.headers().size());
                    if (numHeaders != 0) {
                        for (Map.Entry entry : options.getHeaders().entries()) {
                            this.assertEquals(msg.headers().get((String)entry.getKey()), entry.getValue());
                        }
                    }
                }
            } else {
                consumer.accept(msg.body());
            }
            this.testComplete();
        });
        reg.completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            this.vertices[1].setTimer(200L, along -> {
                if (options == null) {
                    this.vertices[0].eventBus().send("some-address1", val);
                } else {
                    this.vertices[0].eventBus().send("some-address1", val, options);
                }
            });
        });
        this.await();
    }

    protected <T, R> void testReply(T val, R received, Consumer<R> consumer, DeliveryOptions options) {
        if (this.vertices == null) {
            this.startNodes(2);
        }
        String str = TestUtils.randomUnicodeString((int)1000);
        MessageConsumer reg = this.vertices[1].eventBus().consumer("some-address1").handler(msg -> {
            this.assertEquals(str, msg.body());
            if (options == null) {
                msg.reply(val);
            } else {
                msg.reply(val, options);
            }
        });
        reg.completionHandler(ar -> {
            this.assertTrue(ar.succeeded());
            this.vertices[1].setTimer(200L, along -> this.vertices[0].eventBus().request("some-address1", (Object)str, this.onSuccess(reply -> {
                if (consumer == null) {
                    this.assertTrue(reply.isSend());
                    this.assertEquals(received, reply.body());
                    if (options != null && options.getHeaders() != null) {
                        this.assertNotNull(reply.headers());
                        this.assertEquals(options.getHeaders().size(), reply.headers().size());
                        for (Map.Entry entry : options.getHeaders().entries()) {
                            this.assertEquals(reply.headers().get((String)entry.getKey()), entry.getValue());
                        }
                    }
                } else {
                    consumer.accept(reply.body());
                }
                this.testComplete();
            })));
        });
        this.await();
    }

    @Test
    public void testLocalHandlerClusteredPublish() throws Exception {
        this.startNodes(2);
        this.waitFor(2);
        this.vertices[1].eventBus().consumer("some-address1", msg -> this.complete()).completionHandler(v1 -> this.vertices[0].eventBus().localConsumer("some-address1", msg -> this.complete()).completionHandler(v2 -> this.vertices[1].setTimer(200L, aLong -> this.vertices[0].eventBus().publish("some-address1", (Object)"foo"))));
        this.await();
    }

    protected <T> void testPublish(final T val, final Consumer<T> consumer) {
        final int numNodes = 3;
        this.startNodes(numNodes);
        final AtomicInteger count = new AtomicInteger();
        final AtomicInteger registerCount = new AtomicInteger(0);
        class MyHandler
        implements Handler<Message<T>> {
            MyHandler() {
            }

            public void handle(Message<T> msg) {
                if (consumer == null) {
                    ZKClusteredEventbusTest.this.assertFalse(msg.isSend());
                    ZKClusteredEventbusTest.this.assertEquals(val, msg.body());
                } else {
                    consumer.accept(msg.body());
                }
                if (count.incrementAndGet() == numNodes - 1) {
                    ZKClusteredEventbusTest.this.testComplete();
                }
            }
        }
        MessageConsumer reg = this.vertices[2].eventBus().consumer("some-address1").handler((Handler)new MyHandler());
        class MyRegisterHandler
        implements Handler<AsyncResult<Void>> {
            MyRegisterHandler() {
            }

            public void handle(AsyncResult<Void> ar) {
                ZKClusteredEventbusTest.this.assertTrue(ar.succeeded());
                if (registerCount.incrementAndGet() == 2) {
                    ZKClusteredEventbusTest.this.vertices[0].setTimer(300L, h -> ZKClusteredEventbusTest.this.vertices[0].eventBus().publish("some-address1", val));
                }
            }
        }
        reg.completionHandler((Handler)new MyRegisterHandler());
        reg = this.vertices[1].eventBus().consumer("some-address1").handler((Handler)new MyHandler());
        reg.completionHandler((Handler)new MyRegisterHandler());
        this.await();
    }

    protected ClusterManager getClusterManager() {
        return this.zkClustered.getClusterManager();
    }
}

