/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.FaultToleranceTest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.zookeeper.MockZKCluster;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ZKFaultToleranceTest
extends FaultToleranceTest {
    private MockZKCluster zkClustered = new MockZKCluster();

    protected void startNodes(int numNodes, VertxOptions options) {
        CountDownLatch latch = new CountDownLatch(numNodes);
        this.vertices = new Vertx[numNodes];
        int i22 = 0;
        while (i22 < numNodes) {
            int index = i22++;
            options.getEventBusOptions().setHost("localhost").setPort(0);
            this.clusteredVertx(options.setClusterManager(this.getClusterManager()), ar -> {
                try {
                    Vertx vertx;
                    if (ar.failed()) {
                        ar.cause().printStackTrace();
                    }
                    this.assertTrue("Failed to start node", ar.succeeded());
                    this.vertices[index] = vertx = (Vertx)ar.result();
                    String classpath = System.getProperty("java.class.path");
                    JsonObject zkClusterConfig = this.zkClustered.getDefaultConfig();
                    Optional<String> testPath = Stream.of(classpath.split(":")).filter(path -> path.contains("test-classes")).findFirst();
                    Assert.assertTrue((boolean)testPath.isPresent());
                    String zkConfigFileName = testPath.get() + "/zookeeper.json";
                    vertx.fileSystem().deleteBlocking(zkConfigFileName);
                    vertx.fileSystem().createFileBlocking(zkConfigFileName);
                    vertx.fileSystem().writeFileBlocking(zkConfigFileName, Buffer.buffer((String)zkClusterConfig.encode()));
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException i22) {
            // empty catch block
        }
        try {
            this.assertTrue(latch.await(2L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            this.fail(e.getMessage());
        }
    }

    @Ignore
    @Test
    public void testFaultTolerance() throws Exception {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.zkClustered.stop();
    }

    protected ClusterManager getClusterManager() {
        return this.zkClustered.getClusterManager();
    }
}

