/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.ClusteredAsyncMapTest;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.zookeeper.MockZKCluster;
import org.junit.Ignore;
import org.junit.Test;

public class ZKClusteredAsyncMapTest
extends ClusteredAsyncMapTest {
    private MockZKCluster zkClustered = new MockZKCluster();

    public void after() throws Exception {
        super.after();
        this.zkClustered.stop();
    }

    @Test
    public void testMapReplaceIfPresentTtl() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.replaceIfPresent((Object)"key", (Object)"old", (Object)"new", 100L).onSuccess(b -> this.fail("operation should not be implemented")).onFailure(t -> {
            this.assertTrue("operation not implemented", t instanceof UnsupportedOperationException);
            this.complete();
        })));
        this.await();
    }

    @Test
    public void testMapReplaceIfPresentTtlWhenNotPresent() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.replaceIfPresent((Object)"key", (Object)"old", (Object)"new", 100L).onSuccess(b -> this.fail("operation should not be implemented")).onFailure(t -> {
            this.assertTrue("operation not implemented", t instanceof UnsupportedOperationException);
            this.complete();
        })));
        this.await();
    }

    @Test
    public void testMapReplaceTtl() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.replace((Object)"key", (Object)"new", 100L).onSuccess(b -> this.fail("operation should not be implemented")).onFailure(t -> {
            this.assertTrue("operation not implemented", t instanceof UnsupportedOperationException);
            this.complete();
        })));
        this.await();
    }

    @Test
    public void testMapReplaceTtlWithPreviousValue() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.replace((Object)"key", (Object)"new", 100L).onSuccess(b -> this.fail("operation should not be implemented")).onFailure(t -> {
            this.assertTrue("operation not implemented", t instanceof UnsupportedOperationException);
            this.complete();
        })));
        this.await();
    }

    protected ClusterManager getClusterManager() {
        return this.zkClustered.getClusterManager();
    }

    @Test
    public void testStoreAndGetBuffer() {
        this.getVertx().sharedData().getAsyncMap("foo", this.onSuccess(map -> map.put((Object)"test", (Object)Buffer.buffer().appendString("Hello"), this.onSuccess(putResult -> map.get((Object)"test", this.onSuccess(myBuffer -> {
            this.assertEquals("Hello", myBuffer.toString());
            this.testComplete();
        }))))));
        this.await();
    }

    @Ignore
    public void testMapPutThenPutTtl() {
    }
}

