/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import com.jayway.awaitility.Awaitility;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.impl.DiscoveryImpl;
import io.vertx.servicediscovery.impl.DiscoveryImplTestBase;
import io.vertx.spi.cluster.zookeeper.MockZKCluster;
import org.junit.After;
import org.junit.Before;

public class ZKDiscoveryImplClusteredTest
extends DiscoveryImplTestBase {
    private MockZKCluster zkClustered = new MockZKCluster();

    @Before
    public void setUp() {
        VertxOptions options = new VertxOptions().setClusterManager(this.zkClustered.getClusterManager());
        options.getEventBusOptions().setHost("localhost").setPort(0);
        Vertx.clusteredVertx((VertxOptions)options, ar -> {
            this.vertx = (Vertx)ar.result();
        });
        Awaitility.await().until(() -> this.vertx != null);
        this.discovery = new DiscoveryImpl(this.vertx, new ServiceDiscoveryOptions());
    }

    @After
    public void tearDown() {
        super.tearDown();
        this.zkClustered.stop();
    }
}

