/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.zookeeper.MockZKCluster;
import io.vertx.test.core.VertxTestBase;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class ConsumerRoundRobinTest
extends VertxTestBase {
    private static final String MESSAGE_ADDRESS = "consumerAddress";

    protected ClusterManager getClusterManager() {
        MockZKCluster zkCluster = new MockZKCluster();
        return zkCluster.getClusterManager();
    }

    private CompletableFuture<Void> addConsumer(int index) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.vertices[0].eventBus().consumer(MESSAGE_ADDRESS, message -> message.reply((Object)index)).completionHandler(event -> {
            if (event.succeeded()) {
                future.complete(null);
            } else {
                future.completeExceptionally(event.cause());
            }
        });
        return future;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(1);
        CountDownLatch latch = new CountDownLatch(1);
        ((CompletableFuture)((CompletableFuture)this.addConsumer(0).thenCompose(aVoid -> this.addConsumer(1))).thenCompose(aVoid -> this.addConsumer(2))).whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.fail((Throwable)throwable);
            } else {
                latch.countDown();
            }
        });
        this.awaitLatch(latch);
    }

    @Test
    public void roundRobin() {
        AtomicInteger counter = new AtomicInteger(0);
        HashSet results = new HashSet();
        Vertx vertx = this.vertices[0];
        vertx.setPeriodic(500L, aLong -> vertx.eventBus().request(MESSAGE_ADDRESS, (Object)"Hi", message -> {
            if (message.failed()) {
                this.fail(message.cause());
            } else {
                Integer result = (Integer)((Message)message.result()).body();
                results.add(result);
                if (counter.incrementAndGet() == 3) {
                    this.assertEquals(results.size(), counter.get());
                    this.testComplete();
                }
            }
        }));
        this.await();
    }
}

