/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper;

import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.spi.cluster.zookeeper.ZookeeperClusterManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.TestingServer;

public class MockZKCluster {
    private final InstanceSpec spec = new InstanceSpec(null, -1, -1, -1, true, -1, 10000, 120);
    private TestingServer server;
    private final List<ZookeeperClusterManager> clusterManagers = new ArrayList<ZookeeperClusterManager>();
    public CuratorFramework curator;

    public MockZKCluster() {
        try {
            this.server = new TestingServer(this.spec, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JsonObject getDefaultConfig() {
        JsonObject config = new JsonObject();
        config.put("zookeeperHosts", (Object)this.server.getConnectString());
        config.put("sessionTimeout", (Object)10000);
        config.put("connectTimeout", (Object)5000);
        config.put("rootPath", (Object)"io.vertx");
        config.put("retry", (Object)new JsonObject().put("initialSleepTime", (Object)500).put("maxTimes", (Object)2));
        return config;
    }

    public void stop() {
        try {
            this.clusterManagers.clear();
            if (this.server == null) {
                this.server = new TestingServer(this.spec, false);
            }
            this.server.restart();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ClusterManager getClusterManager() {
        if (this.server == null) {
            try {
                this.server = new TestingServer(this.spec, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ZookeeperClusterManager zookeeperClusterManager = new ZookeeperClusterManager(this.getDefaultConfig());
        this.clusterManagers.add(zookeeperClusterManager);
        return zookeeperClusterManager;
    }

    static {
        System.setProperty("zookeeper.extendedTypesEnabled", "true");
    }
}

