/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper;

import io.vertx.spi.cluster.zookeeper.impl.ZKSyncMap;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.apache.curator.test.Timing;
import org.junit.Assert;
import org.junit.Test;

public class ZKSyncMapTest {
    @Test
    public void syncMapOperation() throws Exception {
        Timing timing = new Timing();
        TestingServer server = new TestingServer();
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(100, 3);
        CuratorFramework curator = CuratorFrameworkFactory.builder().namespace("io.vertx").sessionTimeoutMs(timing.session()).connectionTimeoutMs(timing.connection()).connectString(server.getConnectString()).retryPolicy((RetryPolicy)retryPolicy).build();
        curator.start();
        String k = "myKey";
        String v = "myValue";
        ZKSyncMap syncMap = new ZKSyncMap(curator, "mapTest");
        syncMap.put((Object)k, (Object)v);
        Assert.assertFalse((boolean)syncMap.isEmpty());
        Assert.assertEquals((Object)syncMap.get((Object)k), (Object)v);
        Assert.assertTrue((syncMap.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)syncMap.containsKey((Object)k));
        Assert.assertTrue((boolean)syncMap.containsValue((Object)v));
        Assert.assertTrue((boolean)syncMap.keySet().contains(k));
        Assert.assertTrue((boolean)syncMap.values().contains(v));
        syncMap.entrySet().forEach(entry -> {
            Assert.assertEquals((Object)k, entry.getKey());
            Assert.assertEquals((Object)v, entry.getValue());
        });
        String value = (String)syncMap.remove((Object)k);
        Assert.assertEquals((Object)value, (Object)v);
        Assert.assertNull((Object)syncMap.get((Object)k));
        syncMap.clear();
        Assert.assertTrue((boolean)syncMap.isEmpty());
    }
}

