/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.RegistrationUpdateEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.zookeeper.CreateMode;

public class SubsMapHelper
implements TreeCacheListener {
    private final CuratorFramework curator;
    private final TreeCache treeCache;
    private final VertxInternal vertx;
    private final NodeSelector nodeSelector;
    private final String nodeId;
    private final ConcurrentMap<String, Set<RegistrationInfo>> ownSubs = new ConcurrentHashMap<String, Set<RegistrationInfo>>();
    private final ConcurrentMap<String, Set<RegistrationInfo>> localSubs = new ConcurrentHashMap<String, Set<RegistrationInfo>>();
    private static final String VERTX_SUBS_NAME = "/__vertx.subs";
    private static final Logger log = LoggerFactory.getLogger(SubsMapHelper.class);
    private static final Function<String, String> keyPath = address -> "/__vertx.subs/" + address;
    private static final Function<RegistrationInfo, String> valuePath = registrationInfo -> registrationInfo.nodeId() + "-" + registrationInfo.seq();
    private static final BiFunction<String, RegistrationInfo, String> fullPath = (address, registrationInfo) -> keyPath.apply((String)address) + "/" + valuePath.apply((RegistrationInfo)registrationInfo);

    public SubsMapHelper(CuratorFramework curator, VertxInternal vertx, NodeSelector nodeSelector, String nodeId) {
        this.curator = curator;
        this.vertx = vertx;
        this.treeCache = new TreeCache(curator, VERTX_SUBS_NAME);
        this.treeCache.getListenable().addListener((Object)this);
        try {
            this.treeCache.start();
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
        this.nodeSelector = nodeSelector;
        this.nodeId = nodeId;
    }

    public void close() {
        this.treeCache.close();
    }

    public void put(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        if (registrationInfo.localOnly()) {
            this.localSubs.compute(address, (add, curr) -> this.addToSet(registrationInfo, (Set<RegistrationInfo>)curr));
            this.fireRegistrationUpdateEvent(address);
            promise.complete();
        } else {
            try {
                Buffer buffer = Buffer.buffer();
                registrationInfo.writeToBuffer(buffer);
                ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)this.curator.create().orSetData().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).inBackground((c, e) -> {
                    if (e.getType() == CuratorEventType.CREATE || e.getType() == CuratorEventType.SET_DATA) {
                        this.vertx.runOnContext(Avoid -> {
                            this.ownSubs.compute(address, (add, curr) -> this.addToSet(registrationInfo, (Set<RegistrationInfo>)curr));
                            promise.complete();
                        });
                    }
                })).withUnhandledErrorListener((arg_0, arg_1) -> ((Logger)log).error(arg_0, arg_1)).forPath(fullPath.apply(address, registrationInfo), buffer.getBytes());
            }
            catch (Exception e2) {
                log.error((Object)String.format("create subs address %s failed.", address), (Throwable)e2);
            }
        }
    }

    private Set<RegistrationInfo> addToSet(RegistrationInfo registrationInfo, Set<RegistrationInfo> curr) {
        Set<RegistrationInfo> res = curr != null ? curr : Collections.synchronizedSet(new LinkedHashSet());
        res.add(registrationInfo);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegistrationInfo> get(String address) {
        ArrayList<Object> list;
        Map map = this.treeCache.getCurrentChildren(keyPath.apply(address));
        Collection<Object> remote = map == null ? Collections.emptyList() : map.values();
        int size = remote.size();
        Set local = (Set)this.localSubs.get(address);
        if (local != null) {
            Set set = local;
            synchronized (set) {
                if ((size += local.size()) == 0) {
                    return Collections.emptyList();
                }
                list = new ArrayList(size);
                list.addAll(local);
            }
        } else {
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList<RegistrationInfo>(size);
        }
        for (ChildData childData : remote) {
            list.add(SubsMapHelper.toRegistrationInfo(childData));
        }
        return list;
    }

    private static RegistrationInfo toRegistrationInfo(ChildData childData) {
        RegistrationInfo registrationInfo = new RegistrationInfo();
        Buffer buffer = Buffer.buffer((byte[])childData.getData());
        registrationInfo.readFromBuffer(0, buffer);
        return registrationInfo;
    }

    public void remove(String address, RegistrationInfo registrationInfo, Promise<Void> promise) {
        try {
            if (registrationInfo.localOnly()) {
                this.localSubs.computeIfPresent(address, (add, curr) -> this.removeFromSet(registrationInfo, (Set<RegistrationInfo>)curr));
                this.fireRegistrationUpdateEvent(address);
                promise.complete();
            } else {
                ((ErrorListenerPathable)((ChildrenDeletable)this.curator.delete().guaranteed()).inBackground((c, e) -> {
                    if (e.getType() == CuratorEventType.DELETE) {
                        this.vertx.runOnContext(aVoid -> {
                            this.ownSubs.computeIfPresent(address, (add, curr) -> this.removeFromSet(registrationInfo, (Set<RegistrationInfo>)curr));
                            promise.complete();
                        });
                    }
                })).forPath(fullPath.apply(address, registrationInfo));
            }
        }
        catch (Exception e2) {
            log.error((Object)String.format("remove subs address %s failed.", address), (Throwable)e2);
            promise.fail((Throwable)e2);
        }
    }

    private Set<RegistrationInfo> removeFromSet(RegistrationInfo registrationInfo, Set<RegistrationInfo> curr) {
        curr.remove(registrationInfo);
        return curr.isEmpty() ? null : curr;
    }

    public void childEvent(CuratorFramework client, TreeCacheEvent event) {
        switch (event.getType()) {
            case NODE_ADDED: 
            case NODE_UPDATED: 
            case NODE_REMOVED: {
                String[] pathElements = event.getData().getPath().split("/", 4);
                if (pathElements.length <= 3) break;
                String addr = pathElements[2];
                this.vertx.executeBlocking(prom -> prom.complete(this.get(addr)), false, ar -> {
                    if (ar.succeeded()) {
                        this.nodeSelector.registrationsUpdated(new RegistrationUpdateEvent(addr, (List)ar.result()));
                    } else {
                        log.trace((Object)"A failure occured while retrieving the updated registrations", ar.cause());
                        this.nodeSelector.registrationsUpdated(new RegistrationUpdateEvent(addr, Collections.emptyList()));
                    }
                });
                break;
            }
            case CONNECTION_SUSPENDED: {
                log.warn((Object)String.format("vertx node %s which connected to zookeeper have been suspended.", this.nodeId));
                break;
            }
            case CONNECTION_LOST: {
                log.warn((Object)String.format("vertx node %s which connected to zookeeper has lost", this.nodeId));
                break;
            }
            case CONNECTION_RECONNECTED: {
                log.info((Object)String.format("vertx node %s have reconnected to zookeeper", this.nodeId));
                this.vertx.runOnContext(aVoid -> {
                    ArrayList<Future> futures = new ArrayList<Future>();
                    for (Map.Entry entry : this.ownSubs.entrySet()) {
                        for (RegistrationInfo registrationInfo : (Set)entry.getValue()) {
                            Promise promise = Promise.promise();
                            this.put((String)entry.getKey(), registrationInfo, (Promise<Void>)promise);
                            futures.add(promise.future());
                        }
                    }
                    CompositeFuture.all(futures).onComplete(ar -> {
                        if (ar.failed()) {
                            log.error((Object)"recover node subs information failed.", ar.cause());
                        } else {
                            log.info((Object)"recover node subs success.");
                        }
                    });
                });
            }
        }
    }

    private void fireRegistrationUpdateEvent(String address) {
        this.nodeSelector.registrationsUpdated(new RegistrationUpdateEvent(address, this.get(address)));
    }
}

