/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.shareddata.Lock;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;

public class ZKLock
implements Lock {
    private static final Logger log = LoggerFactory.getLogger(ZKLock.class);
    private final InterProcessSemaphoreMutex lock;
    private final ExecutorService lockReleaseExec;

    public ZKLock(InterProcessSemaphoreMutex lock, ExecutorService lockReleaseExec) {
        this.lock = lock;
        this.lockReleaseExec = lockReleaseExec;
    }

    public InterProcessSemaphoreMutex getLock() {
        return this.lock;
    }

    public void release() {
        this.lockReleaseExec.execute(() -> {
            try {
                this.lock.release();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        });
    }
}

