/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.Counter;
import java.util.Objects;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;

public class ZKCounter
implements Counter {
    private static final String ZK_PATH_COUNTERS = "/counters/";
    private final VertxInternal vertx;
    private final DistributedAtomicLong atomicLong;

    public ZKCounter(VertxInternal vertx, CuratorFramework curator, String nodeName, RetryPolicy retryPolicy) {
        this.vertx = vertx;
        String counterPath = ZK_PATH_COUNTERS + nodeName;
        this.atomicLong = new DistributedAtomicLong(curator, counterPath, retryPolicy);
    }

    public Future<Long> get() {
        return this.vertx.executeBlocking(future -> {
            try {
                future.complete(this.atomicLong.get().preValue());
            }
            catch (Exception e) {
                future.fail((Throwable)new VertxException((Throwable)e));
            }
        });
    }

    public void get(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler);
        this.get().onComplete(resultHandler);
    }

    public Future<Long> incrementAndGet() {
        return this.increment(true);
    }

    public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler);
        this.incrementAndGet().onComplete(resultHandler);
    }

    public Future<Long> getAndIncrement() {
        return this.increment(false);
    }

    public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler);
        this.getAndIncrement().onComplete(resultHandler);
    }

    private Future<Long> increment(boolean post) {
        return this.vertx.executeBlocking(future -> {
            try {
                long returnValue = 0L;
                if (this.atomicLong.get().succeeded()) {
                    returnValue = (Long)this.atomicLong.get().preValue();
                }
                if (this.atomicLong.increment().succeeded()) {
                    future.complete((Object)(post ? (Long)this.atomicLong.get().postValue() : Long.valueOf(returnValue)));
                } else {
                    future.fail((Throwable)new VertxException("increment value failed."));
                }
            }
            catch (Exception e) {
                future.fail((Throwable)new VertxException((Throwable)e));
            }
        });
    }

    public Future<Long> decrementAndGet() {
        return this.vertx.executeBlocking(future -> {
            try {
                if (this.atomicLong.decrement().succeeded()) {
                    future.complete(this.atomicLong.get().postValue());
                } else {
                    future.fail((Throwable)new VertxException("decrement value failed."));
                }
            }
            catch (Exception e) {
                future.fail((Throwable)new VertxException((Throwable)e));
            }
        });
    }

    public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler);
        this.decrementAndGet().onComplete(resultHandler);
    }

    public Future<Long> addAndGet(long value) {
        return this.add(value, true);
    }

    public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler);
        this.addAndGet(value).onComplete(resultHandler);
    }

    public Future<Long> getAndAdd(long value) {
        return this.add(value, false);
    }

    public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler);
        this.getAndAdd(value).onComplete(resultHandler);
    }

    private Future<Long> add(long value, boolean post) {
        return this.vertx.executeBlocking(future -> {
            try {
                long returnValue = 0L;
                if (this.atomicLong.get().succeeded()) {
                    returnValue = (Long)this.atomicLong.get().preValue();
                }
                if (this.atomicLong.add(Long.valueOf(value)).succeeded()) {
                    future.complete((Object)(post ? (Long)this.atomicLong.get().postValue() : Long.valueOf(returnValue)));
                } else {
                    future.fail((Throwable)new VertxException("add value failed."));
                }
            }
            catch (Exception e) {
                future.fail((Throwable)new VertxException((Throwable)e));
            }
        });
    }

    public Future<Boolean> compareAndSet(long expected, long value) {
        return this.vertx.executeBlocking(future -> {
            try {
                if (this.atomicLong.get().succeeded() && (Long)this.atomicLong.get().preValue() == 0L) {
                    this.atomicLong.initialize(Long.valueOf(0L));
                }
                future.complete((Object)this.atomicLong.compareAndSet(Long.valueOf(expected), Long.valueOf(value)).succeeded());
            }
            catch (Exception e) {
                future.fail((Throwable)new VertxException((Throwable)e));
            }
        });
    }

    public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) {
        Objects.requireNonNull(resultHandler);
        this.compareAndSet(expected, value).onComplete(resultHandler);
    }
}

