/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.VertxException;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.spi.cluster.zookeeper.impl.ZKMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ZKSyncMap<K, V>
extends ZKMap<K, V>
implements Map<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(ZKSyncMap.class);

    public ZKSyncMap(CuratorFramework curator, String mapName) {
        super(curator, null, "syncMap", mapName);
    }

    @Override
    public int size() {
        try {
            return ((List)this.curator.getChildren().forPath(this.mapPath)).size();
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.syncKeyPath(this.mapPath);
            return ((List)this.curator.getChildren().forPath(this.mapPath)).isEmpty();
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            String keyPath = this.keyPath(key);
            this.syncKeyPath(keyPath);
            return this.curator.checkExists().forPath(keyPath) != null;
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            this.syncKeyPath(this.mapPath);
            return ((List)this.curator.getChildren().forPath(this.mapPath)).stream().anyMatch(k -> {
                try {
                    byte[] bytes = (byte[])this.curator.getData().forPath(this.keyPath(k));
                    KeyValue keyValue = (KeyValue)this.asObject(bytes);
                    return keyValue.getValue().equals(value);
                }
                catch (Exception ex) {
                    throw new VertxException((Throwable)ex);
                }
            });
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public V get(Object key) {
        try {
            String keyPath = this.keyPath(key);
            this.syncKeyPath(keyPath);
            if (null == this.curator.checkExists().forPath(keyPath)) {
                return null;
            }
            KeyValue keyValue = (KeyValue)this.asObject((byte[])this.curator.getData().forPath(keyPath));
            return keyValue.getValue();
        }
        catch (Exception e) {
            if (!(e instanceof VertxException) || !(e.getCause() instanceof KeeperException.NoNodeException)) {
                throw new VertxException((Throwable)e);
            }
            logger.warn((Object)("zookeeper node lost. " + e.getCause().getMessage()));
            return null;
        }
    }

    @Override
    public V put(K key, V value) {
        try {
            String keyPath = this.keyPath(key);
            KeyValue<K, V> keyValue = new KeyValue<K, V>(key, value);
            byte[] valueBytes = this.asByte(keyValue);
            if (this.get(key) != null) {
                this.curator.setData().forPath(keyPath, valueBytes);
            } else {
                ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(CreateMode.CONTAINER)).forPath(keyPath, valueBytes);
            }
            return value;
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public V remove(Object key) {
        try {
            V result = this.get(key);
            if (result != null) {
                this.curator.delete().deletingChildrenIfNeeded().forPath(this.keyPath(key));
            }
            return result;
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.entrySet().stream().forEach((? super T entry) -> this.put(entry.getKey(), entry.getValue()));
    }

    @Override
    public void clear() {
        try {
            this.curator.delete().deletingChildrenIfNeeded().forPath(this.mapPath);
            ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(CreateMode.CONTAINER)).forPath(this.mapPath);
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Override
    public Set<K> keySet() {
        try {
            this.syncKeyPath(this.mapPath);
            return ((List)this.curator.getChildren().forPath(this.mapPath)).stream().map(k -> {
                try {
                    KeyValue keyValue = (KeyValue)this.asObject((byte[])this.curator.getData().forPath(this.keyPath(k)));
                    return keyValue.getKey();
                }
                catch (KeeperException.NoNodeException nodeLostEx) {
                    logger.warn((Object)("node lost " + nodeLostEx.getMessage()));
                    return null;
                }
                catch (Exception ex) {
                    throw new VertxException((Throwable)ex);
                }
            }).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            throw new VertxException((Throwable)ex);
        }
    }

    @Override
    public Collection<V> values() {
        try {
            this.syncKeyPath(this.mapPath);
            return ((List)this.curator.getChildren().forPath(this.mapPath)).stream().map(k -> {
                try {
                    KeyValue keyValue = (KeyValue)this.asObject((byte[])this.curator.getData().forPath(this.keyPath(k)));
                    return keyValue.getValue();
                }
                catch (Exception ex) {
                    throw new VertxException((Throwable)ex);
                }
            }).collect(Collectors.toSet());
        }
        catch (Exception ex) {
            throw new VertxException((Throwable)ex);
        }
    }

    private void syncKeyPath(String path) {
        block3: {
            CountDownLatch latch = new CountDownLatch(1);
            try {
                ((ErrorListenerPathable)this.curator.sync().inBackground((client, event) -> {
                    if (client.getState() == CuratorFrameworkState.STOPPED) {
                        latch.countDown();
                        return;
                    }
                    if (event.getPath().equals(path) && event.getType() == CuratorEventType.SYNC) {
                        latch.countDown();
                    }
                })).forPath(path);
                latch.await(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (e instanceof KeeperException.NoNodeException) break block3;
                throw new VertxException((Throwable)e);
            }
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.keySet().stream().map(k -> {
            V v = this.get(k);
            return new AbstractMap.SimpleImmutableEntry<Object, V>(k, v);
        }).collect(Collectors.toSet());
    }

    static class KeyValue<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6529685098267757690L;
        private K key;
        private V value;

        public KeyValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

