/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import org.apache.curator.RetryPolicy;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.retry.RetryUntilElapsed;

public class RetryPolicyHelper {
    private static final String DEFAULT_RETRY_POLICY = "exponential_backoff";
    private static final Logger log = LoggerFactory.getLogger(RetryPolicyHelper.class);

    public static RetryPolicy createRetryPolicy(JsonObject conf) {
        String policy = conf.getString("policy", DEFAULT_RETRY_POLICY);
        int initialSleepTime = conf.getInteger("initialSleepTime", Integer.valueOf(1000));
        int maxTimes = conf.getInteger("maxTimes", Integer.valueOf(5));
        int intervalTimes = conf.getInteger("intervalTimes", Integer.valueOf(10000));
        switch (policy) {
            case "bounded_exponential_backoff": {
                return new BoundedExponentialBackoffRetry(initialSleepTime, maxTimes, intervalTimes);
            }
            case "one_time": {
                return new RetryOneTime(intervalTimes);
            }
            case "n_times": {
                return new RetryNTimes(maxTimes, intervalTimes);
            }
            case "forever": {
                return new RetryForever(intervalTimes);
            }
            case "until_elapsed": {
                return new RetryUntilElapsed(maxTimes, intervalTimes);
            }
            case "exponential_backoff": {
                return new ExponentialBackoffRetry(initialSleepTime, maxTimes, intervalTimes);
            }
        }
        log.warn((Object)String.format("%s is not a valid policy, falling back to %s", policy, DEFAULT_RETRY_POLICY));
        return new ExponentialBackoffRetry(initialSleepTime, maxTimes, intervalTimes);
    }

    private RetryPolicyHelper() {
    }
}

