/*
 * Decompiled with CFR 0.152.
 */
package io.vinyldns.java;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.HttpResponseHandler;
import com.google.gson.Gson;
import io.vinyldns.java.GetGroupRequest;
import io.vinyldns.java.VinylDNSClient;
import io.vinyldns.java.VinylDNSClientConfig;
import io.vinyldns.java.VinylDNSRequest;
import io.vinyldns.java.handlers.ErrorResponseHandler;
import io.vinyldns.java.handlers.StringResponseHandler;
import io.vinyldns.java.model.Methods;
import io.vinyldns.java.model.batch.BatchChangeReview;
import io.vinyldns.java.model.batch.BatchResponse;
import io.vinyldns.java.model.batch.CreateBatchRequest;
import io.vinyldns.java.model.batch.GetRecordSetRequest;
import io.vinyldns.java.model.batch.ListBatchChangesRequest;
import io.vinyldns.java.model.batch.ListBatchChangesResponse;
import io.vinyldns.java.model.membership.CreateGroupRequest;
import io.vinyldns.java.model.membership.DeleteGroupRequest;
import io.vinyldns.java.model.membership.Group;
import io.vinyldns.java.model.membership.ListAdminsResponse;
import io.vinyldns.java.model.membership.ListGroupActivityRequest;
import io.vinyldns.java.model.membership.ListGroupActivityResponse;
import io.vinyldns.java.model.membership.ListGroupsRequest;
import io.vinyldns.java.model.membership.ListGroupsResponse;
import io.vinyldns.java.model.membership.ListMembersRequest;
import io.vinyldns.java.model.membership.ListMembersResponse;
import io.vinyldns.java.model.membership.UpdateGroupRequest;
import io.vinyldns.java.model.record.set.CreateRecordSetRequest;
import io.vinyldns.java.model.record.set.DeleteRecordSetRequest;
import io.vinyldns.java.model.record.set.GetRecordSetChangeRequest;
import io.vinyldns.java.model.record.set.ListRecordSetChangesRequest;
import io.vinyldns.java.model.record.set.ListRecordSetChangesResponse;
import io.vinyldns.java.model.record.set.ListRecordSetsRequest;
import io.vinyldns.java.model.record.set.ListRecordSetsResponse;
import io.vinyldns.java.model.record.set.RecordSetChange;
import io.vinyldns.java.model.record.set.UpdateRecordSetRequest;
import io.vinyldns.java.model.zone.GetRecordSetResponse;
import io.vinyldns.java.model.zone.GetZoneResponse;
import io.vinyldns.java.model.zone.ListZoneChangesRequest;
import io.vinyldns.java.model.zone.ListZoneChangesResponse;
import io.vinyldns.java.model.zone.ListZonesRequest;
import io.vinyldns.java.model.zone.ListZonesResponse;
import io.vinyldns.java.model.zone.Zone;
import io.vinyldns.java.model.zone.ZoneRequest;
import io.vinyldns.java.model.zone.ZoneResponse;
import io.vinyldns.java.responses.VinylDNSFailureResponse;
import io.vinyldns.java.responses.VinylDNSResponse;
import io.vinyldns.java.responses.VinylDNSSuccessResponse;
import io.vinyldns.java.serializers.SerializationFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class VinylDNSClientImpl
implements VinylDNSClient {
    private VinylDNSClientConfig config;
    private AmazonHttpClient client;
    Gson gson = SerializationFactory.createGson();

    public VinylDNSClientImpl(VinylDNSClientConfig config) {
        this.config = config;
        this.client = new AmazonHttpClient(new ClientConfiguration());
    }

    public VinylDNSClientImpl() {
        this.config = new VinylDNSClientConfig(System.getenv("VINYLDNS_API_URL"), (AWSCredentials)new BasicAWSCredentials(System.getenv("VINYLDNS_ACCESS_KEY_ID"), System.getenv("VINYLDNS_SECRET_ACCESS_KEY")), SignerFactory.getSigner((String)"VinylDNS", (String)"us/east"));
        this.client = new AmazonHttpClient(new ClientConfiguration());
    }

    @Override
    public VinylDNSResponse<ListZonesResponse> listZones(ListZonesRequest request) {
        VinylDNSRequest<Object> vinylDNSRequest = new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), "zones", null);
        if (request.getStartFrom() != null) {
            vinylDNSRequest.addParameter("startFrom", request.getStartFrom());
        }
        if (request.getMaxItems() != null) {
            vinylDNSRequest.addParameter("maxItems", request.getMaxItems().toString());
        }
        if (request.getNameFilter() != null) {
            vinylDNSRequest.addParameter("nameFilter", request.getNameFilter());
        }
        return this.executeRequest(vinylDNSRequest, ListZonesResponse.class);
    }

    @Override
    public VinylDNSResponse<ZoneResponse> createZone(Zone zone) {
        return this.executeRequest(new VinylDNSRequest<Zone>(Methods.POST.name(), this.getBaseUrl(), "zones", zone), ZoneResponse.class);
    }

    @Override
    public VinylDNSResponse<GetZoneResponse> getZone(ZoneRequest request) {
        String path = "zones/" + request.getZoneId();
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null), GetZoneResponse.class);
    }

    @Override
    public VinylDNSResponse<GetZoneResponse> getZoneByName(String zoneName) {
        String path = "zones/name/" + zoneName;
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null), GetZoneResponse.class);
    }

    @Override
    public VinylDNSResponse<ZoneResponse> updateZone(Zone zone) {
        String path = "zones/" + zone.getId();
        return this.executeRequest(new VinylDNSRequest<Zone>(Methods.PUT.name(), this.getBaseUrl(), path, zone), ZoneResponse.class);
    }

    @Override
    public VinylDNSResponse<ZoneResponse> deleteZone(ZoneRequest request) {
        String path = "zones/" + request.getZoneId();
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.DELETE.name(), this.getBaseUrl(), path, null), ZoneResponse.class);
    }

    @Override
    public VinylDNSResponse<ListZoneChangesResponse> listZoneChanges(ListZoneChangesRequest request) {
        String path = "zones/" + request.getZoneId() + "/changes";
        VinylDNSRequest<Object> vinylDNSRequest = new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null);
        if (request.getStartFrom() != null) {
            vinylDNSRequest.addParameter("startFrom", request.getStartFrom());
        }
        if (request.getMaxItems() != null) {
            vinylDNSRequest.addParameter("maxItems", request.getMaxItems().toString());
        }
        return this.executeRequest(vinylDNSRequest, ListZoneChangesResponse.class);
    }

    @Override
    public VinylDNSResponse<ZoneResponse> syncZone(ZoneRequest request) {
        String path = "zones/" + request.getZoneId() + "/sync";
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.POST.name(), this.getBaseUrl(), path, null), ZoneResponse.class);
    }

    @Override
    public VinylDNSResponse<ListRecordSetsResponse> listRecordSets(ListRecordSetsRequest request) {
        String path = "zones/" + request.getZoneId() + "/recordsets";
        VinylDNSRequest<Object> vinylDNSRequest = new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null);
        if (request.getStartFrom() != null) {
            vinylDNSRequest.addParameter("startFrom", request.getStartFrom());
        }
        if (request.getMaxItems() != null) {
            vinylDNSRequest.addParameter("maxItems", request.getMaxItems().toString());
        }
        if (request.getRecordNameFilter() != null) {
            vinylDNSRequest.addParameter("recordNameFilter", request.getRecordNameFilter());
        }
        return this.executeRequest(vinylDNSRequest, ListRecordSetsResponse.class);
    }

    @Override
    public VinylDNSResponse<Group> getGroup(GetGroupRequest request) {
        String path = "groups/" + request.getId();
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null), Group.class);
    }

    @Override
    public VinylDNSResponse<Group> createGroup(CreateGroupRequest request) {
        return this.executeRequest(new VinylDNSRequest<CreateGroupRequest>(Methods.POST.name(), this.getBaseUrl(), "groups", request), Group.class);
    }

    @Override
    public VinylDNSResponse<Group> updateGroup(UpdateGroupRequest request) {
        String path = "groups/" + request.getGroupId();
        return this.executeRequest(new VinylDNSRequest<UpdateGroupRequest>(Methods.PUT.name(), this.getBaseUrl(), path, request), Group.class);
    }

    @Override
    public VinylDNSResponse<Group> deleteGroup(DeleteGroupRequest request) {
        String path = "/groups/" + request.getId();
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.DELETE.name(), this.getBaseUrl(), path, null), Group.class);
    }

    @Override
    public VinylDNSResponse<ListGroupsResponse> listGroups(ListGroupsRequest request) {
        VinylDNSRequest<Object> vinylDNSRequest = new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), "groups", null);
        if (request.getGroupNameFilter() != null) {
            vinylDNSRequest.addParameter("groupNameFilter", request.getGroupNameFilter());
        }
        if (request.getStartFrom() != null) {
            vinylDNSRequest.addParameter("startFrom", request.getStartFrom());
        }
        if (request.getMaxItems() != null) {
            vinylDNSRequest.addParameter("maxItems", request.getMaxItems().toString());
        }
        return this.executeRequest(vinylDNSRequest, ListGroupsResponse.class);
    }

    @Override
    public VinylDNSResponse<ListAdminsResponse> listAdmins(String groupId) {
        String path = "groups/" + groupId + "/admins";
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null), ListAdminsResponse.class);
    }

    @Override
    public VinylDNSResponse<ListMembersResponse> listMembers(ListMembersRequest request) {
        String path = "groups/" + request.getGroupId() + "/members";
        VinylDNSRequest<Object> vinylDNSRequest = new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null);
        if (request.getStartFrom() != null) {
            vinylDNSRequest.addParameter("startFrom", request.getStartFrom());
        }
        if (request.getMaxItems() != null) {
            vinylDNSRequest.addParameter("maxItems", request.getMaxItems().toString());
        }
        return this.executeRequest(vinylDNSRequest, ListMembersResponse.class);
    }

    @Override
    public VinylDNSResponse<ListGroupActivityResponse> listGroupActivity(ListGroupActivityRequest request) {
        String path = "groups/" + request.getGroupId() + "/activity";
        VinylDNSRequest<Object> vinylDNSRequest = new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null);
        if (request.getStartFrom() != null) {
            vinylDNSRequest.addParameter("startFrom", request.getStartFrom());
        }
        if (request.getMaxItems() != null) {
            vinylDNSRequest.addParameter("maxItems", request.getMaxItems().toString());
        }
        return this.executeRequest(vinylDNSRequest, ListGroupActivityResponse.class);
    }

    @Override
    public VinylDNSResponse<RecordSetChange> createRecordSet(CreateRecordSetRequest request) {
        String path = "zones/" + request.getZoneId() + "/recordsets";
        return this.executeRequest(new VinylDNSRequest<CreateRecordSetRequest>(Methods.POST.name(), this.getBaseUrl(), path, request), RecordSetChange.class);
    }

    @Override
    public VinylDNSResponse<GetRecordSetResponse> getRecordSet(GetRecordSetRequest request) {
        String path = "zones/" + request.getZoneId() + "/recordsets/" + request.getRecordSetId();
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null), GetRecordSetResponse.class);
    }

    @Override
    public VinylDNSResponse<RecordSetChange> updateRecordSet(UpdateRecordSetRequest request) {
        String path = "zones/" + request.getZoneId() + "/recordsets/" + request.getId();
        return this.executeRequest(new VinylDNSRequest<UpdateRecordSetRequest>(Methods.PUT.name(), this.getBaseUrl(), path, request), RecordSetChange.class);
    }

    @Override
    public VinylDNSResponse<RecordSetChange> deleteRecordSet(DeleteRecordSetRequest request) {
        String path = "zones/" + request.getZoneId() + "/recordsets/" + request.getRecordSetId();
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.DELETE.name(), this.getBaseUrl(), path, null), RecordSetChange.class);
    }

    @Override
    public VinylDNSResponse<ListRecordSetChangesResponse> listRecordSetChanges(ListRecordSetChangesRequest request) {
        String path = "zones/" + request.getZoneId() + "/recordsetchanges";
        VinylDNSRequest<Object> vinylDNSRequest = new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null);
        if (request.getStartFrom() != null) {
            vinylDNSRequest.addParameter("startFrom", request.getStartFrom());
        }
        if (request.getMaxItems() != null) {
            vinylDNSRequest.addParameter("maxItems", request.getMaxItems().toString());
        }
        return this.executeRequest(vinylDNSRequest, ListRecordSetChangesResponse.class);
    }

    @Override
    public VinylDNSResponse<RecordSetChange> getRecordSetChange(GetRecordSetChangeRequest request) {
        String path = "zones/" + request.getZoneId() + "/recordsets/" + request.getRecordSetId() + "/changes/" + request.getRecordSetChangeId();
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null), RecordSetChange.class);
    }

    @Override
    public VinylDNSResponse<ListBatchChangesResponse> listBatchChanges(ListBatchChangesRequest request) {
        String path = "zones/batchrecordchanges";
        VinylDNSRequest<Object> vinylDNSRequest = new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null);
        if (request.getStartFrom() != null) {
            vinylDNSRequest.addParameter("startFrom", request.getStartFrom());
        }
        if (request.getMaxItems() != null) {
            vinylDNSRequest.addParameter("maxItems", request.getMaxItems().toString());
        }
        if (request.getIgnoreAccess() != null) {
            vinylDNSRequest.addParameter("ignoreAccess", request.getIgnoreAccess().toString());
        }
        if (request.getApprovalStatus() != null) {
            vinylDNSRequest.addParameter("approvalStatus", request.getApprovalStatus().toString());
        }
        return this.executeRequest(vinylDNSRequest, ListBatchChangesResponse.class);
    }

    @Override
    public VinylDNSResponse<BatchResponse> getBatchChanges(String id) {
        String path = "zones/batchrecordchanges/" + id;
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.GET.name(), this.getBaseUrl(), path, null), BatchResponse.class);
    }

    @Override
    public VinylDNSResponse<BatchResponse> createBatchChanges(CreateBatchRequest request) {
        String path = "zones/batchrecordchanges";
        VinylDNSRequest<CreateBatchRequest> vinylDNSRequest = new VinylDNSRequest<CreateBatchRequest>(Methods.POST.name(), this.getBaseUrl(), path, request);
        if (request.getAllowManualReview() != null) {
            vinylDNSRequest.addParameter("allowManualReview", request.getAllowManualReview().toString());
        }
        return this.executeRequest(vinylDNSRequest, BatchResponse.class);
    }

    @Override
    public VinylDNSResponse<BatchResponse> approveBatchChanges(String id) {
        String path = "zones/batchrecordchanges/" + id + "/approve";
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.POST.name(), this.getBaseUrl(), path, null), BatchResponse.class);
    }

    @Override
    public VinylDNSResponse<BatchResponse> approveBatchChanges(String id, String reviewComment) {
        String path = "zones/batchrecordchanges/" + id + "/approve";
        return this.executeRequest(new VinylDNSRequest<BatchChangeReview>(Methods.POST.name(), this.getBaseUrl(), path, new BatchChangeReview(reviewComment)), BatchResponse.class);
    }

    @Override
    public VinylDNSResponse<BatchResponse> rejectBatchChanges(String id) {
        String path = "zones/batchrecordchanges/" + id + "/reject";
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.POST.name(), this.getBaseUrl(), path, null), BatchResponse.class);
    }

    @Override
    public VinylDNSResponse<BatchResponse> rejectBatchChanges(String id, String reviewComment) {
        String path = "zones/batchrecordchanges/" + id + "/reject";
        return this.executeRequest(new VinylDNSRequest<BatchChangeReview>(Methods.POST.name(), this.getBaseUrl(), path, new BatchChangeReview(reviewComment)), BatchResponse.class);
    }

    @Override
    public VinylDNSResponse<BatchResponse> cancelBatchChanges(String id) {
        String path = "zones/batchrecordchanges/" + id + "/cancel";
        return this.executeRequest(new VinylDNSRequest<Object>(Methods.POST.name(), this.getBaseUrl(), path, null), BatchResponse.class);
    }

    private <S, R> VinylDNSResponse<R> executeRequest(VinylDNSRequest<S> req, Class<R> responseType) {
        DefaultRequest request = new DefaultRequest("VinylDNS");
        request.setEndpoint(req.getEndpoint());
        request.setResourcePath(req.getResourcePath());
        request.setHttpMethod(req.getHttpMethod());
        request.setHeaders(req.getHeaders());
        request.setParameters(req.getParameters());
        request.addHeader("Content-Type", "application/json");
        if (req.getPayload() != null) {
            String content = this.gson.toJson(req.getPayload());
            try {
                request.setContent((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.config.getSigner().sign((SignableRequest)request, this.config.getCredentials());
        try {
            Response response = this.client.requestExecutionBuilder().errorResponseHandler((HttpResponseHandler)new ErrorResponseHandler()).request((Request)request).execute((HttpResponseHandler)new StringResponseHandler());
            int statusCode = response.getHttpResponse().getStatusCode();
            String messageBody = (String)response.getAwsResponse();
            if (statusCode / 100 * 100 == 200) {
                Object responseObject = this.gson.fromJson(messageBody, responseType);
                return new VinylDNSSuccessResponse<Object>(responseObject, messageBody, statusCode);
            }
            return new VinylDNSFailureResponse(messageBody, statusCode);
        }
        catch (AmazonServiceException e) {
            return new VinylDNSFailureResponse(e.getRawResponseContent(), e.getStatusCode());
        }
    }

    private String getBaseUrl() {
        if (this.config.getBaseUrl().endsWith("/")) {
            return this.config.getBaseUrl();
        }
        return this.config.getBaseUrl() + "/";
    }
}

