/*
 * Decompiled with CFR 0.152.
 */
package io.vinyldns.java;

import com.amazonaws.http.HttpMethodName;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VinylDNSRequest<T> {
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private final URI uri;
    private final HttpMethodName methodName;
    private final String resourcePath;
    private final T payload;

    public VinylDNSRequest(String method, String url, String path, T payload) {
        this.uri = URI.create(url);
        this.payload = payload;
        this.methodName = HttpMethodName.valueOf((String)method);
        this.resourcePath = path;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void addParameter(String name, String value) {
        List match = this.parameters.getOrDefault(name, new ArrayList());
        match.add(value);
        this.parameters.put(name, match);
    }

    public T getPayload() {
        return this.payload;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public URI getEndpoint() {
        return this.uri;
    }

    public HttpMethodName getHttpMethod() {
        return this.methodName;
    }
}

