/*
 * Decompiled with CFR 0.152.
 */
package io.vinyldns.java.model.membership;

import io.vinyldns.java.model.membership.GroupStatus;
import io.vinyldns.java.model.membership.UserInfo;
import java.util.Collections;
import java.util.Set;
import org.joda.time.DateTime;

public class Group {
    private final String name;
    private final String email;
    private String id;
    private String description;
    private DateTime created;
    private GroupStatus status;
    private final Set<UserInfo> members;
    private final Set<UserInfo> admins;

    public Group(String name, String email, Set<UserInfo> members, Set<UserInfo> admins) {
        this.name = name;
        this.email = email;
        this.members = members;
        this.admins = admins;
    }

    public Group(String name, String email) {
        this(name, email, Collections.emptySet(), Collections.emptySet());
    }

    public Group(String name, String email, Set<UserInfo> members, Set<UserInfo> admins, String id, String description, DateTime created, GroupStatus status) {
        this(name, email, members, admins);
        this.id = id;
        this.description = description;
        this.created = created;
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setStatus(GroupStatus status) {
        this.status = status;
    }

    public GroupStatus getStatus() {
        return this.status;
    }

    public Set<UserInfo> getMembers() {
        return this.members;
    }

    public Set<UserInfo> getAdmins() {
        return this.admins;
    }

    public String toString() {
        return "Group{name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", description='" + this.description + '\'' + ", id='" + this.id + '\'' + ", created='" + this.created + '\'' + ", status=" + (Object)((Object)this.status) + ", members=" + this.members + ", admins=" + this.admins + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        if (!this.name.equals(group.name)) {
            return false;
        }
        if (!this.email.equals(group.email)) {
            return false;
        }
        if (!this.id.equals(group.id)) {
            return false;
        }
        if (!this.created.equals((Object)group.created)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(group.description) : group.description != null) {
            return false;
        }
        if (this.status != group.status) {
            return false;
        }
        if (!this.members.equals(group.members)) {
            return false;
        }
        return this.admins.equals(group.admins);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.email.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.created.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.status.hashCode();
        result = 31 * result + this.members.hashCode();
        result = 31 * result + this.admins.hashCode();
        return result;
    }
}

