/*
 * Decompiled with CFR 0.152.
 */
package io.vinyldns.java.model.membership;

import io.vinyldns.java.model.membership.GroupStatus;
import io.vinyldns.java.model.membership.MemberId;
import java.util.Objects;
import java.util.Set;
import org.joda.time.DateTime;

public class UpdateGroupRequest {
    private final String id;
    private final String name;
    private final String email;
    private final String groupId;
    private String description;
    private final Set<MemberId> members;
    private final Set<MemberId> admins;
    private DateTime created;
    private GroupStatus status;

    public UpdateGroupRequest(String id, String groupId, String name, String email, Set<MemberId> members, Set<MemberId> admins, DateTime created, GroupStatus status) {
        this.id = id;
        this.groupId = groupId;
        this.name = name;
        this.email = email;
        this.members = members;
        this.admins = admins;
        this.created = created;
        this.status = status;
    }

    public UpdateGroupRequest(String id, String groupId, String name, String email, Set<MemberId> members, Set<MemberId> admins, DateTime created, GroupStatus status, String description) {
        this(id, groupId, name, email, members, admins, created, status);
        this.description = description;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<MemberId> getMembers() {
        return this.members;
    }

    public Set<MemberId> getAdmins() {
        return this.admins;
    }

    public String getId() {
        return this.id;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public GroupStatus getStatus() {
        return this.status;
    }

    public void setStatus(GroupStatus status) {
        this.status = status;
    }

    public String toString() {
        return "UpdateGroupRequest{id='" + this.id + '\'' + ",groupId='" + this.groupId + '\'' + ", name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", description='" + this.description + '\'' + ", members=" + this.members + ", admins=" + this.admins + ", created=" + this.created + ", status=" + (Object)((Object)this.status) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest that = (UpdateGroupRequest)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getEmail(), that.getEmail()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getMembers(), that.getMembers()) && Objects.equals(this.getAdmins(), that.getAdmins()) && Objects.equals(this.getCreated(), that.getCreated()) && this.getStatus() == that.getStatus();
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.email.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.members.hashCode();
        result = 31 * result + this.admins.hashCode();
        result = 31 * result + this.created.hashCode();
        result = 31 * result + this.status.hashCode();
        return result;
    }
}

