/*
 * Decompiled with CFR 0.152.
 */
package io.vinyldns.java.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.vinyldns.java.model.batch.SingleChange;
import java.lang.reflect.Type;

public class ChangeInputDeserializer
implements JsonDeserializer<SingleChange>,
JsonSerializer<SingleChange> {
    public JsonElement serialize(SingleChange src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src, src.getClass()).getAsJsonObject();
    }

    public SingleChange deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement typeElement = jsonObject.get("changeType");
        if (typeElement.isJsonNull()) {
            throw new JsonParseException("Unknown element changeType: null");
        }
        String type = typeElement.getAsString();
        try {
            String thepackage = SingleChange.class.getPackage().getName() + ".";
            return (SingleChange)context.deserialize((JsonElement)jsonObject, Class.forName(thepackage + type + SingleChange.class.getSimpleName()));
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonParseException("Unknown element changeType: " + type, (Throwable)cnfe);
        }
    }
}

