/*
 * Decompiled with CFR 0.152.
 */
package io.vinyldns.java.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class InstantSerializer
implements JsonSerializer<Instant>,
JsonDeserializer<Instant> {
    public Instant deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        return Instant.parse(jsonElement.getAsString());
    }

    public JsonElement serialize(Instant instant, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(instant.truncatedTo(ChronoUnit.SECONDS).toString());
    }
}

