/*
 * Decompiled with CFR 0.152.
 */
package io.vinyldns.java.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.vinyldns.java.model.record.data.RecordData;
import io.vinyldns.java.model.record.data.UNKNOWNData;
import java.lang.reflect.Type;

public class RecordDataDeserializer
implements JsonDeserializer<RecordData>,
JsonSerializer<RecordData> {
    public JsonElement serialize(RecordData src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src, src.getClass()).getAsJsonObject();
    }

    public RecordData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement typeElement = jsonObject.get("type");
        if (typeElement.isJsonNull()) {
            return new UNKNOWNData(json.getAsString());
        }
        String type = typeElement.getAsString();
        try {
            String thepackage = RecordData.class.getPackage().getName() + ".";
            return (RecordData)context.deserialize((JsonElement)jsonObject, Class.forName(thepackage + type + "Data"));
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonParseException("Unknown element type: " + type, (Throwable)cnfe);
        }
    }
}

