/*
 * Decompiled with CFR 0.152.
 */
package io.vinyldns.java.serializers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.vinyldns.java.model.record.set.CreateRecordSetRequest;
import io.vinyldns.java.model.record.set.RecordSet;
import java.io.IOException;

public class RecordSetTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        if (!type.getType().equals(CreateRecordSetRequest.class) && !type.getType().equals(RecordSet.class)) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                delegate.write(out, value);
            }

            public T read(JsonReader in) throws IOException {
                JsonElement tree = (JsonElement)gson.fromJson(in, JsonElement.class);
                JsonObject jsonObject = tree.getAsJsonObject();
                JsonElement records = jsonObject.get("records");
                if (records.isJsonNull()) {
                    return delegate.fromJsonTree((JsonElement)jsonObject);
                }
                JsonElement type = jsonObject.get("type");
                for (JsonElement element : records.getAsJsonArray()) {
                    element.getAsJsonObject().add("type", type);
                }
                return delegate.fromJsonTree((JsonElement)jsonObject);
            }
        };
    }
}

