/*
 * Decompiled with CFR 0.152.
 */
package io.vinyldns.java.serializers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.vinyldns.java.model.batch.AddSingleChange;
import io.vinyldns.java.model.batch.DeleteRecordSetSingleChange;
import java.io.IOException;

public class SingleChangeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        if (!type.getType().equals(AddSingleChange.class) && !type.getType().equals(DeleteRecordSetSingleChange.class)) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                delegate.write(out, value);
            }

            public T read(JsonReader in) throws IOException {
                JsonElement tree = (JsonElement)gson.fromJson(in, JsonElement.class);
                JsonObject jsonObject = tree.getAsJsonObject();
                JsonElement record = jsonObject.get("record");
                if (record == null || record.isJsonNull()) {
                    return delegate.fromJsonTree((JsonElement)jsonObject);
                }
                JsonElement type = jsonObject.get("type");
                record.getAsJsonObject().add("type", type);
                return delegate.fromJsonTree((JsonElement)jsonObject);
            }
        };
    }
}

