/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.common;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMultimap<K, V, C extends Collection<V>>
implements Map<K, C> {
    protected Map<K, C> map;

    public AbstractMultimap(Map<K, C> map) {
        this.map = map;
    }

    protected abstract C createNewCollection();

    @Override
    public void putAll(Map<? extends K, ? extends C> m) {
        this.map.putAll(m);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public C get(Object key) {
        return (C)((Collection)this.map.get(key));
    }

    @Override
    public C remove(Object key) {
        return (C)((Collection)this.map.remove(key));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<C> values() {
        return this.map.values();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public synchronized void putElement(K key, V value) {
        Collection<Object> collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = this.createNewCollection();
            this.map.put(key, collection);
        }
        collection.add(value);
    }

    @Override
    public C put(K key, C value) {
        return (C)((Collection)this.map.put(key, value));
    }

    @Override
    public Set<Map.Entry<K, C>> entrySet() {
        return this.map.entrySet();
    }

    public synchronized boolean putElements(K key, Collection<V> values) {
        Collection<Object> collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = this.createNewCollection();
            this.map.put(key, collection);
        }
        return collection.addAll(values);
    }

    public synchronized boolean removeElement(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return false;
        }
        boolean removed = collection.remove(value);
        if (collection.isEmpty()) {
            this.map.remove(key);
        }
        return removed;
    }

    public synchronized boolean containsElement(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.contains(value);
    }

    public synchronized boolean containsElement(V value) {
        for (Collection collection : this.map.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    public synchronized C valuesElements() {
        C all = this.createNewCollection();
        for (Collection collection : this.map.values()) {
            all.addAll(collection);
        }
        return all;
    }
}

