/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.common;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ObjectCache<KEY, VALUE> {
    private final Map<KEY, CacheEntry<VALUE>> values;
    private final ReferenceType referenceType;
    private final boolean isStrongReference;
    private final int maxSize;
    private final long expirationMillis;
    private final boolean isExpiring;
    private volatile long nextCleanUpTimestamp;
    private volatile int countPutCountSinceEviction;
    private volatile int countPut;
    private volatile int countHit;
    private volatile int countMiss;
    private volatile int countExpired;
    private volatile int countRefCleared;
    private volatile int countEvicted;

    public ObjectCache(ReferenceType referenceType, int maxSize, long expirationMillis) {
        this.referenceType = referenceType;
        this.isStrongReference = referenceType == ReferenceType.STRONG;
        this.maxSize = maxSize;
        this.expirationMillis = expirationMillis;
        this.isExpiring = expirationMillis > 0L;
        this.values = new LinkedHashMap<KEY, CacheEntry<VALUE>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VALUE put(KEY key, VALUE object) {
        CacheEntry<Object> oldEntry;
        CacheEntry<Object> entry = this.referenceType == ReferenceType.WEAK ? new CacheEntry<Object>(new WeakReference<VALUE>(object), null) : (this.referenceType == ReferenceType.SOFT ? new CacheEntry<Object>(new SoftReference<VALUE>(object), null) : new CacheEntry<VALUE>(null, object));
        ++this.countPutCountSinceEviction;
        ++this.countPut;
        if (this.isExpiring && this.nextCleanUpTimestamp == 0L) {
            this.nextCleanUpTimestamp = System.currentTimeMillis() + this.expirationMillis + 1L;
        }
        ObjectCache objectCache = this;
        synchronized (objectCache) {
            if (this.values.size() >= this.maxSize) {
                this.evictToTargetSize(this.maxSize - 1);
            }
            oldEntry = this.values.put(key, entry);
        }
        return this.getValueForRemoved(oldEntry);
    }

    private VALUE getValueForRemoved(CacheEntry<VALUE> entry) {
        if (entry != null) {
            return (VALUE)(this.isStrongReference ? entry.referenceStrong : entry.reference.get());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VALUE getValue(KEY keyForRemoval, CacheEntry<VALUE> entry) {
        if (entry != null) {
            if (this.isStrongReference) {
                return (VALUE)entry.referenceStrong;
            }
            Object value = entry.reference.get();
            if (value == null) {
                ++this.countRefCleared;
                if (keyForRemoval != null) {
                    ObjectCache objectCache = this;
                    synchronized (objectCache) {
                        this.values.remove(keyForRemoval);
                    }
                }
            }
            return (VALUE)value;
        }
        return null;
    }

    public void putAll(Map<KEY, VALUE> mapDataToPut) {
        int targetSize = this.maxSize - mapDataToPut.size();
        if (this.maxSize > 0 && this.values.size() > targetSize) {
            this.evictToTargetSize(targetSize);
        }
        Set<Map.Entry<KEY, VALUE>> entries = mapDataToPut.entrySet();
        for (Map.Entry<KEY, VALUE> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VALUE get(KEY key) {
        Object value;
        CacheEntry<VALUE> entry;
        ObjectCache objectCache = this;
        synchronized (objectCache) {
            entry = this.values.get(key);
        }
        if (entry != null) {
            if (this.isExpiring) {
                long age = System.currentTimeMillis() - entry.timeCreated;
                if (age < this.expirationMillis) {
                    value = this.getValue(key, entry);
                } else {
                    ++this.countExpired;
                    ObjectCache objectCache2 = this;
                    synchronized (objectCache2) {
                        this.values.remove(key);
                    }
                    value = null;
                }
            } else {
                value = this.getValue(key, entry);
            }
        } else {
            value = null;
        }
        if (value != null) {
            ++this.countHit;
        } else {
            ++this.countMiss;
        }
        return value;
    }

    public synchronized void clear() {
        this.values.clear();
    }

    public VALUE remove(KEY key) {
        return this.getValueForRemoved(this.values.remove(key));
    }

    public synchronized void evictToTargetSize(int targetSize) {
        if (targetSize <= 0) {
            this.values.clear();
        } else {
            this.checkCleanUpObsoleteEntries();
            Iterator<KEY> keys = this.values.keySet().iterator();
            while (keys.hasNext() && this.values.size() > targetSize) {
                ++this.countEvicted;
                keys.next();
                keys.remove();
            }
        }
    }

    void checkCleanUpObsoleteEntries() {
        if ((!this.isStrongReference || this.isExpiring) && (this.isExpiring && this.nextCleanUpTimestamp != 0L && System.currentTimeMillis() > this.nextCleanUpTimestamp || this.countPutCountSinceEviction > this.maxSize / 2)) {
            this.cleanUpObsoleteEntries();
        }
    }

    public synchronized int cleanUpObsoleteEntries() {
        this.countPutCountSinceEviction = 0;
        this.nextCleanUpTimestamp = 0L;
        int countCleaned = 0;
        long timeLimit = this.isExpiring ? System.currentTimeMillis() - this.expirationMillis : 0L;
        Set<Map.Entry<KEY, CacheEntry<VALUE>>> entries = this.values.entrySet();
        for (Map.Entry<KEY, CacheEntry<VALUE>> entry : entries) {
            CacheEntry<VALUE> cacheEntry = entry.getValue();
            if (!this.isStrongReference && cacheEntry.reference == null) {
                ++this.countRefCleared;
                ++countCleaned;
                this.values.remove(entry.getKey());
                continue;
            }
            if (cacheEntry.timeCreated >= timeLimit) continue;
            ++this.countExpired;
            ++countCleaned;
            this.values.remove(entry.getKey());
        }
        return countCleaned;
    }

    public synchronized boolean containsKey(KEY key) {
        return this.values.containsKey(key);
    }

    public boolean containsKeyWithValue(KEY key) {
        return this.get(key) != null;
    }

    public synchronized Set<KEY> keySet() {
        return this.values.keySet();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public synchronized int size() {
        return this.values.size();
    }

    public int getCountPut() {
        return this.countPut;
    }

    public int getCountHit() {
        return this.countHit;
    }

    public int getCountMiss() {
        return this.countMiss;
    }

    public int getCountExpired() {
        return this.countExpired;
    }

    public int getCountRefCleared() {
        return this.countRefCleared;
    }

    public int getCountEvicted() {
        return this.countEvicted;
    }

    public String toString() {
        return "ObjectCache[maxSize=" + this.maxSize + ", hits=" + this.countHit + ", misses=" + this.countMiss + "]";
    }

    public String getStatsStringRemoved() {
        return "ObjectCache-Removed[expired=" + this.countExpired + ", refCleared=" + this.countRefCleared + ", evicted=" + this.countEvicted;
    }

    static class CacheEntry<V> {
        final Reference<V> reference;
        final V referenceStrong;
        final long timeCreated;

        CacheEntry(Reference<V> reference, V referenceStrong) {
            this.reference = reference;
            this.referenceStrong = referenceStrong;
            this.timeCreated = System.currentTimeMillis();
        }
    }

    public static enum ReferenceType {
        SOFT,
        WEAK,
        STRONG;

    }
}

