/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.common;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringUtils {
    public static String[] fastSplit(String string, char delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        int size = string.length();
        int start = 0;
        for (int i = 0; i < size; ++i) {
            if (string.charAt(i) == delimiter) {
                if (start < i) {
                    list.add(string.substring(start, i));
                } else {
                    list.add("");
                }
                start = i + 1;
                continue;
            }
            if (i != size - 1) continue;
            list.add(string.substring(start, size));
        }
        String[] elements = new String[list.size()];
        list.toArray(elements);
        return elements;
    }

    public static String encodeUrl(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static String encodeUrlIso(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static String decodeUrl(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static String decodeUrlIso(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static String generateMD5String(String stringToEncode) {
        return StringUtils.generateDigestString(stringToEncode, "MD5", "UTF-8", 32);
    }

    public static String generateSHA1String(String stringToEncode) {
        return StringUtils.generateDigestString(stringToEncode, "SHA-1", "UTF-8", 40);
    }

    public static String generateDigestString(String stringToEncode, String digestAlgo, String encoding, int lengthToPad) {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance(digestAlgo);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
        try {
            digester.update(stringToEncode.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return StringUtils.toHexString(digester.digest(), lengthToPad);
    }

    public static String toHexString(byte[] bytes, int lengthToPad) {
        BigInteger hash = new BigInteger(1, bytes);
        String digest = hash.toString(16);
        while (digest.length() < lengthToPad) {
            digest = "0" + digest;
        }
        return digest;
    }

    public static String resolveEntity(String entity) {
        if (entity.length() > 1 && entity.charAt(0) == '#') {
            if (entity.charAt(1) == 'x') {
                return String.valueOf((char)Integer.parseInt(entity.substring(2), 16));
            }
            return String.valueOf((char)Integer.parseInt(entity.substring(1)));
        }
        if (entity.equals("apos")) {
            return "'";
        }
        if (entity.equals("quot")) {
            return "\"";
        }
        if (entity.equals("gt")) {
            return ">";
        }
        if (entity.equals("lt")) {
            return "<";
        }
        if (entity.equals("amp")) {
            return "&";
        }
        return entity;
    }

    public static String ellipsize(String text, int maxLength) {
        if (text != null && text.length() > maxLength) {
            return text.substring(0, maxLength - 3) + "...";
        }
        return text;
    }

    public static String[] splitLines(String text, boolean skipEmptyLines) {
        if (skipEmptyLines) {
            return text.split("[\n\r]+");
        }
        return text.split("\\r?\\n");
    }

    public static List<String> findLinesContaining(String text, String searchText) {
        String[] splitLinesSkipEmpty = StringUtils.splitLines(text, true);
        ArrayList<String> matching = new ArrayList<String>();
        for (String line : splitLinesSkipEmpty) {
            if (!line.contains(searchText)) continue;
            matching.add(line);
        }
        return matching;
    }

    public static String concatLines(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        int countMinus1 = lines.size() - 1;
        for (int i = 0; i < countMinus1; ++i) {
            builder.append(lines.get(i)).append('\n');
        }
        if (!lines.isEmpty()) {
            builder.append(lines.get(countMinus1));
        }
        return builder.toString();
    }

    public static String joinIterableOnComma(Iterable<?> iterable) {
        if (iterable != null) {
            StringBuilder buf = new StringBuilder();
            Iterator<?> it = iterable.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append(',');
            }
            return buf.toString();
        }
        return "";
    }

    public static String joinArrayOnComma(int[] array) {
        if (array != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
            return buf.toString();
        }
        return "";
    }

    public static String joinArrayOnComma(String[] array) {
        if (array != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(array[i]);
            }
            return buf.toString();
        }
        return "";
    }
}

