/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.ArrayList;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafeMapper
public class Template
implements LongFunction<String> {
    private static final String EXPR_BEGIN = "[[";
    private static final String EXPR_END = "]]";
    private static final ThreadLocal<StringBuilder> sb = ThreadLocal.withInitial(StringBuilder::new);
    private final String rawTemplate;
    private LongUnaryOperator iterOp;
    private String[] literals;
    private LongFunction<?>[] funcs;

    @Example(value={"Template('{}-{}',Add(10),Hash())", "concatenate input+10, '-', and a pseudo-random long"})
    public Template(String template, LongFunction<?> ... funcs) {
        this.funcs = funcs;
        this.rawTemplate = template;
        this.literals = this.parseTemplate(template, funcs);
    }

    public Template(LongUnaryOperator iterOp, String template, LongFunction<?> ... funcs) {
        this(template, funcs);
        this.iterOp = iterOp;
    }

    private String[] parseTemplate(String template, LongFunction<?> ... funcs) {
        try {
            ArrayList<String> literals = new ArrayList<String>();
            Pattern p = Pattern.compile("\\{}");
            Matcher m = p.matcher(template);
            int pos = 0;
            while (m.find()) {
                literals.add(template.substring(pos, m.start()));
                pos = m.end();
            }
            literals.add(template.substring(pos));
            if (literals.size() != funcs.length + 1) {
                throw new RuntimeException("The number of {} place holders in '" + template + "' should equal the number of functions.");
            }
            return literals.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String apply(long value) {
        StringBuilder buffer = sb.get();
        buffer.setLength(0);
        buffer.append(this.literals[0]);
        if (this.literals.length > 1) {
            for (int i = 0; i < this.funcs.length; ++i) {
                long input = this.iterOp != null ? this.iterOp.applyAsLong(value + (long)i) : value + (long)i;
                String genString = String.valueOf(this.funcs[i].apply(input));
                buffer.append(genString);
                buffer.append(this.literals[i + 1]);
            }
        }
        return buffer.toString();
    }
}

