/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_uuid;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class)
public class ToUUIDAutoDocsInfo
implements DocFuncData {
    @Override
    public String getClassName() {
        return "ToUUID";
    }

    @Override
    public String getPackageName() {
        return "io.virtdata.basicsmappers.from_long.to_uuid";
    }

    @Override
    public String getClassJavadoc() {
        return "This function creates a non-random UUID in the type 4 version (Random).\nIt always puts the same value in the MSB position of the UUID format.\nThe input value is put in the LSB position.\n<pre>\nxxxxxxxx-xxxx-Mxxx-Nxxx-xxxxxxxxxxxx\nmmmmmmmm-mmmm-Mmmm-Llll-llllllllllll\n              4    3\n</pre>\nAs shown above, the LSB position does not have the complication of having\na version identifier (position M) dividing the dynamic range of the data type.\nFor this reason, only the LSB side is used for this mapper, which allows\nan effective range of Long.MAX_VALUE/8, given the loss of 3 digits of precision.\n\nThis function is suitable for deterministic testing of scenarios which depend\non type 4 UUIDs, but without the mandated randomness that makes testing difficult.\nJust be aware that the MSB will always contain value 0x0123456789ABCDEFL unless you\nspecify a different long value to pre-fill it with.\n";
    }

    @Override
    public String getInType() {
        return "long";
    }

    @Override
    public String getOutType() {
        return "java.util.UUID";
    }

    @Override
    public Category[] getCategories() {
        return new Category[0];
    }

    @Override
    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("ToUUID", "", (Map<String, String>)new LinkedHashMap<String, String>(){}, (List<List<String>>)new ArrayList<List<String>>(){}));
                this.add(new DocForFuncCtor("ToUUID", "", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("msbs", "long");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){}));
            }
        };
    }
}

