/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapperLibrary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMapperLibraryFinder {
    private static final Logger logger = LoggerFactory.getLogger(DataMapperLibrary.class);
    private static final Map<String, DataMapperLibrary> libraries = new ConcurrentHashMap<String, DataMapperLibrary>();

    private DataMapperLibraryFinder() {
    }

    public static synchronized DataMapperLibrary get(String libraryName) {
        Optional<DataMapperLibrary> at = Optional.ofNullable(DataMapperLibraryFinder.getLibraries().get(libraryName));
        return at.orElseThrow(() -> new RuntimeException("DataMapperLibrary '" + libraryName + "' not found."));
    }

    private static synchronized Map<String, DataMapperLibrary> getLibraries() {
        if (libraries.size() == 0) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            logger.debug("loading DataMapper Libraries");
            ServiceLoader<DataMapperLibrary> sl = ServiceLoader.load(DataMapperLibrary.class);
            HashMap<String, Integer> dups = new HashMap<String, Integer>();
            for (DataMapperLibrary dataMapperLibrary : sl) {
                logger.debug("Found data mapper library:" + dataMapperLibrary.getClass().getCanonicalName() + ":" + dataMapperLibrary.getLibraryName());
                if (libraries.get(dataMapperLibrary.getLibraryName()) != null) {
                    String name = dataMapperLibrary.getLibraryName();
                    dups.put(name, dups.getOrDefault(name, 0));
                }
                libraries.put(dataMapperLibrary.getLibraryName(), dataMapperLibrary);
            }
            if (dups.size() > 0) {
                logger.trace("Java runtime provided duplicates for " + dups.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(",")));
            }
        }
        logger.info("Loaded DataMapper Libraries:" + libraries.keySet());
        return libraries;
    }

    public static synchronized List<DataMapperLibrary> getAll() {
        ArrayList<DataMapperLibrary> libraries = new ArrayList<DataMapperLibrary>(DataMapperLibraryFinder.getLibraries().values());
        libraries.sort((o1, o2) -> o1.getLibraryName().compareTo(o2.getLibraryName()));
        return Collections.unmodifiableList(libraries);
    }
}

