/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.reflection;

import io.virtdata.reflection.DeferredConstructor;
import io.virtdata.util.StringObjectPromoter;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructorResolver {
    private static final Logger logger = LoggerFactory.getLogger(ConstructorResolver.class);
    private Exception lastException;

    public static <T> Optional<T> resolveAndConstructOptional(String[] classAndArgs) {
        Optional<DeferredConstructor<DeferredConstructor>> optionalDeferredConstructor = ConstructorResolver.createOptionalDeferredConstructor(classAndArgs);
        return optionalDeferredConstructor.map(DeferredConstructor::construct);
    }

    public static <T> T resolveAndConstruct(String[] classAndArgs) {
        DeferredConstructor<T> deferredConstructor = ConstructorResolver.createDeferredConstructorRequired(classAndArgs);
        T constructed = deferredConstructor.construct();
        return constructed;
    }

    public static <T> DeferredConstructor<T> resolve(String[] classAndArgs) {
        DeferredConstructor<T> deferredConstructor = ConstructorResolver.createDeferredConstructorRequired(classAndArgs);
        return deferredConstructor;
    }

    public static <T> DeferredConstructor<T> resolve(Class<T> clazz, String ... args) {
        DeferredConstructor<T> deferredConstructor = ConstructorResolver.createDeferredConstructorRequired(clazz, args);
        return deferredConstructor;
    }

    public static <T> Optional<DeferredConstructor<T>> resolveOptional(Class<T> clazz, String ... args) {
        Optional<DeferredConstructor<T>> optionalResolved = ConstructorResolver.createOptionalDeferredConstructor(clazz, args);
        return optionalResolved;
    }

    public static <T> DeferredConstructor<T> resolve(String className, String[] args) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        DeferredConstructor<?> deferredConstructor = ConstructorResolver.createDeferredConstructorRequired(clazz, args);
        return deferredConstructor;
    }

    private static <T> DeferredConstructor<T> createDeferredConstructorRequired(String[] signature) {
        Class<?> clazz;
        String className = signature[0];
        if (!className.contains(".")) {
            throw new RuntimeException(ConstructorResolver.class.getSimpleName() + " needs a fully qualified package name.");
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return ConstructorResolver.createDeferredConstructorRequired(clazz, Arrays.copyOfRange(signature, 1, signature.length));
    }

    private static Object[] specializeArgs(String[] raw, Class<?>[] targetTypes) {
        Object[] made = new Object[raw.length];
        for (int paramidx = 0; paramidx < targetTypes.length; ++paramidx) {
            Class<?> ptype = targetTypes[paramidx];
            made[paramidx] = StringObjectPromoter.promote(raw[paramidx], ptype);
            if (StringObjectPromoter.isAssignableForConstructor(made[paramidx].getClass(), ptype)) continue;
            return null;
        }
        return made;
    }

    private static Predicate<Constructor> canAssignToConstructor(final String[] args) {
        return new Predicate<Constructor>(){

            @Override
            public boolean test(Constructor ctor) {
                Object[] objects = ConstructorResolver.specializeArgs(args, ctor.getParameterTypes());
                return objects != null;
            }
        };
    }

    private static <T> Optional<? extends DeferredConstructor<T>> createOptionalDeferredConstructor(String ... classAndArgs) {
        Class<?> ctorClass = null;
        try {
            ctorClass = Class.forName(classAndArgs[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (ctorClass != null) {
            Optional<DeferredConstructor<?>> odc = ConstructorResolver.createOptionalDeferredConstructor(ctorClass, Arrays.copyOfRange(classAndArgs, 1, classAndArgs.length));
            return odc;
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    private static <T> Optional<DeferredConstructor<T>> createOptionalDeferredConstructor(Class<T> clazz, String ... args) {
        void var5_8;
        List<Object> matchingConstructors = new ArrayList();
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            Constructor<?> constructor = constructorArray[var5_8];
            if (constructor.getParameterCount() == args.length) {
                matchingConstructors.add(constructor);
            }
            ++var5_8;
        }
        if ((matchingConstructors = matchingConstructors.stream().filter(ConstructorResolver.canAssignToConstructor(args)).collect(Collectors.toList())).size() == 0) {
            logger.debug("no constructor found for " + clazz.getSimpleName() + " with " + args.length + " parameters");
            return Optional.empty();
        }
        if (matchingConstructors.size() > 1) {
            ArrayList<String> signatures = new ArrayList<String>();
            for (Constructor constructor : matchingConstructors) {
                Class<?>[] pt = constructor.getParameterTypes();
                signatures.add(Arrays.stream(pt).map(Class::getSimpleName).collect(Collectors.joining(",", "(", ")")));
            }
            String diagnosticList = signatures.stream().collect(Collectors.joining(",", "[", "]"));
            logger.error("Multiple constructors found for " + clazz.getSimpleName() + " with " + args.length + " parameters:" + diagnosticList);
            return Optional.empty();
        }
        Constructor matchingConstructor = (Constructor)matchingConstructors.get(0);
        Object[] ctorArgs = ConstructorResolver.specializeArgs(args, matchingConstructor.getParameterTypes());
        try {
            ConstructorUtils.invokeConstructor(clazz, ctorArgs);
        }
        catch (Exception exception) {
            logger.error("Unable to invoke constructor as sanity check for args:" + Arrays.toString(ctorArgs), exception);
            return Optional.empty();
        }
        DeferredConstructor<T> deferredConstructor = new DeferredConstructor<T>(clazz, ctorArgs);
        return Optional.of(deferredConstructor);
    }

    private static <T> DeferredConstructor<T> createDeferredConstructorRequired(Class<T> clazz, String ... args) {
        Optional<DeferredConstructor<T>> optional = ConstructorResolver.createOptionalDeferredConstructor(clazz, args);
        return optional.orElseThrow(() -> new RuntimeException("Unable to create deferred constructor for class:" + clazz.getCanonicalName() + " and args: " + Arrays.toString(args)));
    }

    private static enum StringMapper {
        STRING(String.class, null, i -> i),
        INTEGER(Integer.class, Integer.TYPE, Integer::valueOf),
        BIGDECIMAL(BigDecimal.class, null, i -> BigDecimal.valueOf(Long.valueOf(i))),
        BOOLEAN(Boolean.class, Boolean.TYPE, Boolean::valueOf),
        SHORT(Short.class, Short.TYPE, Short::valueOf),
        BYTE(Byte.class, Byte.TYPE, Byte::valueOf),
        DOUBLE(Double.class, Double.TYPE, Double::valueOf),
        CHAR(Character.class, Character.TYPE, c -> Character.valueOf(c.charAt(0))),
        FLOAT(Float.class, Float.TYPE, Float::valueOf),
        LONG(Long.class, Long.TYPE, Long::valueOf);

        private final Class<?> targetClass;
        private final Class<?> primitiveClass;
        private final Function<String, ?> mapperFunction;

        private <T> StringMapper(Class<T> targetClass, Class<?> primitiveName, Function<String, T> mapperFunction) {
            this.targetClass = targetClass;
            this.mapperFunction = mapperFunction;
            this.primitiveClass = primitiveName;
        }

        public static Optional<StringMapper> valueOf(Class<?> targetClass) {
            for (StringMapper stringMapper : StringMapper.values()) {
                if (stringMapper.getTargetClass().equals(targetClass)) {
                    return Optional.of(stringMapper);
                }
                if (stringMapper.primitiveClass == null || !stringMapper.primitiveClass.equals(targetClass)) continue;
                return Optional.of(stringMapper);
            }
            throw new RuntimeException("StringMapper could not match " + targetClass);
        }

        public static Object mapValue(String value, Class<?> targetClass) {
            Optional<StringMapper> mapper = StringMapper.valueOf(targetClass);
            if (mapper.isPresent()) {
                return mapper.get().getMapperFunction().apply(value);
            }
            throw new RuntimeException("Unable to find type mapper for String and class " + targetClass.getCanonicalName());
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public Function<String, ?> getMapperFunction() {
            return this.mapperFunction;
        }
    }
}

