/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.stathelpers.aliasmethod;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.basicsmappers.from_long.to_long.Hash;
import io.virtdata.stathelpers.EvProbD;
import io.virtdata.stathelpers.aliasmethod.AliasSamplerDoubleInt;
import io.virtdata.util.ResourceFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.LongFunction;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

@ThreadSafeMapper
public class WeightedStrings
implements LongFunction<String> {
    private final String[] filenames;
    private final String valueColumn;
    private final String weightColumn;
    private final String[] lines;
    private final AliasSamplerDoubleInt sampler;
    private Hash hash;

    public WeightedStrings(String valueColumn, String weightColumn, String ... filenames) {
        this.filenames = filenames;
        this.valueColumn = valueColumn;
        this.weightColumn = weightColumn;
        ArrayList<EvProbD> events = new ArrayList<EvProbD>();
        ArrayList<String> values = new ArrayList<String>();
        if (filenames[0].equals("map")) {
            filenames = Arrays.copyOfRange(filenames, 1, filenames.length);
            this.hash = null;
        } else {
            if (filenames[0].equals("hash")) {
                filenames = Arrays.copyOfRange(filenames, 1, filenames.length);
            }
            this.hash = new Hash();
        }
        for (String filename : filenames) {
            CSVParser csvdata = ResourceFinder.readFileCSV(filename, new String[0]);
            for (CSVRecord csvdatum : csvdata) {
                String value = csvdatum.get(valueColumn);
                values.add(value);
                String weight = csvdatum.get(weightColumn);
                events.add(new EvProbD(values.size() - 1, Double.valueOf(weight)));
            }
        }
        this.sampler = new AliasSamplerDoubleInt(events);
        this.lines = values.toArray(new String[0]);
    }

    @Override
    public String apply(long value) {
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unitValue = (double)value / 9.223372036854776E18;
        int idx = this.sampler.applyAsInt(unitValue);
        return this.lines[idx];
    }
}

