/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.templates;

import io.virtdata.api.ValuesBinder;
import io.virtdata.core.Bindings;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class StringCompositor
implements ValuesBinder<StringCompositor, String> {
    private String[] templateSegments;
    private Function<Object, String> stringfunc = String::valueOf;

    public StringCompositor(String template) {
        this.templateSegments = this.parseTemplate(template);
    }

    public StringCompositor(String template, Function<Object, String> stringfunc) {
        this(template);
        this.stringfunc = stringfunc;
    }

    protected String[] parseSection(String template) {
        int i;
        StringBuilder literalBuf = new StringBuilder();
        for (i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == '\\') {
                c = template.charAt(++i);
                literalBuf.append(c);
                continue;
            }
            if (c != '{') {
                literalBuf.append(c);
                continue;
            }
            ++i;
            break;
        }
        StringBuilder tokenBuf = new StringBuilder();
        while (i < template.length()) {
            char c = template.charAt(i);
            if (c == '}') {
                ++i;
                break;
            }
            tokenBuf.append(c);
            ++i;
        }
        String literal = literalBuf.toString();
        String token = tokenBuf.toString();
        if (token.length() > 0) {
            return new String[]{literalBuf.toString(), tokenBuf.toString(), template.substring(i)};
        }
        return new String[]{literalBuf.toString()};
    }

    protected String[] parseTemplate(String template) {
        ArrayList<String> sections = new ArrayList<String>();
        String[] parts = this.parseSection(template);
        while (parts.length > 0) {
            sections.add(parts[0]);
            if (parts.length > 1) {
                sections.add(parts[1]);
            }
            parts = parts.length >= 2 ? this.parseSection(parts[2]) : new String[]{};
        }
        if (sections.size() % 2 == 0) {
            sections.add("");
        }
        return sections.toArray(new String[0]);
    }

    @Override
    public String bindValues(StringCompositor context, Bindings bindings, long cycle) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.templateSegments.length; ++i) {
            if (i % 2 == 0) {
                sb.append(this.templateSegments[i]);
                continue;
            }
            String key = this.templateSegments[i];
            Object value = bindings.get(key, cycle);
            String valueString = this.stringfunc.apply(value);
            sb.append(valueString);
        }
        return sb.toString();
    }

    public List<String> getBindPointNames() {
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = 0; i < this.templateSegments.length; ++i) {
            if (i % 2 != 1) continue;
            tokens.add(this.templateSegments[i]);
        }
        return tokens;
    }
}

