/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.csvson;

import io.virtualan.mapson.Mapson;
import io.virtualan.mapson.exception.BadInputDataException;
import io.virtualan.util.Helper;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Csvson {
    private static final Logger log = LoggerFactory.getLogger(Csvson.class);

    public static JSONArray buildCSVson(List<String> csvline, Map<String, String> contextObject) throws BadInputDataException {
        String heading = csvline.get(0);
        List<String> list = csvline.subList(1, csvline.size());
        JSONArray array = new JSONArray();
        for (String s : list) {
            JSONObject object = Csvson.splitRow(heading, Helper.getActualValueForAll(s, contextObject).toString());
            array.put((Object)object);
        }
        return array;
    }

    private static JSONObject splitRow(String heading, String row) throws BadInputDataException {
        String[] rows;
        String[] headings = heading.split("(?<!\\\\),");
        if (headings.length != (rows = row.split("(?<!\\\\),")).length) {
            log.error("Check the input number of column does not match >>> " + heading + " : " + row);
            throw new BadInputDataException("Check the input number of column does not match >>> " + heading + " : " + row);
        }
        Map rowMap = IntStream.range(0, headings.length).mapToObj(i -> new AbstractMap.SimpleEntry<String, String>(Csvson.removeVirtualanCommaEscape(headings[i]), Csvson.removeVirtualanCommaEscape(rows[i]))).collect(LinkedHashMap::new, (m, v) -> m.put(((String)v.getKey()).trim(), ((String)v.getValue()).trim()), HashMap::putAll);
        List mapsonList = rowMap.entrySet().stream().map(Csvson::buildKeyValuePairBase).flatMap(Collection::stream).collect(Collectors.toList());
        Map mapson = mapsonList.stream().collect(LinkedHashMap::new, (m, v) -> {
            String cfr_ignored_0 = (String)m.put(v.getKey(), v.getValue());
        }, HashMap::putAll);
        return Mapson.buildMAPsonAsJsonObject(mapson);
    }

    private static List<AbstractMap.SimpleEntry<String, String>> buildKeyValuePairBase(Map.Entry<String, String> entry) {
        String[] subElementParent = entry.getKey().split("/");
        String prefix = subElementParent[0];
        String[] subElement = Csvson.indexExists(subElementParent, 1) ? subElementParent[1].split("(?<!\\\\):") : null;
        String[] subArrayElementValue = entry.getValue().split("\\|");
        String[] subElementValue = entry.getValue().split("(?<!\\\\):");
        boolean isArray = entry.getValue().endsWith("|");
        Stream<List> streamArrayElement = null;
        if (subElement != null && subArrayElementValue != null) {
            streamArrayElement = subArrayElementValue.length >= 1 && isArray ? IntStream.range(0, subArrayElementValue.length).mapToObj(i -> Csvson.getArrayElementList(prefix, subElement, subArrayElementValue[i].split("(?<!\\\\):"), i)) : IntStream.range(0, 1).mapToObj(i -> Csvson.getElementList(prefix, subElement, subElementValue));
            List<AbstractMap.SimpleEntry<String, String>> subElementMap = streamArrayElement.flatMap(Collection::stream).collect(Collectors.toList());
            System.out.println(subElementMap);
            return subElementMap;
        }
        if (subArrayElementValue != null && subArrayElementValue.length >= 1 && isArray) {
            return IntStream.range(0, subArrayElementValue.length).mapToObj(i -> new AbstractMap.SimpleEntry<String, String>(prefix + "[" + i + "]", subArrayElementValue[i])).collect(Collectors.toList());
        }
        AbstractMap.SimpleEntry<String, String> singleEntry = new AbstractMap.SimpleEntry<String, String>(entry.getKey(), entry.getValue());
        ArrayList<AbstractMap.SimpleEntry<String, String>> list = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        list.add(singleEntry);
        return list;
    }

    private static List<AbstractMap.SimpleEntry<String, String>> buildKeyValuePair(Map.Entry<String, String> entry) {
        String[] subElementParent = entry.getKey().split("/");
        String prefix = subElementParent[0];
        String[] subElement = subElementParent[1].split("(?<!\\\\):");
        String[] subArrayElementValue = entry.getValue().split("\\|");
        String[] subElementValue = entry.getValue().split("(?<!\\\\):");
        Stream<List> streamArrayElement = null;
        if (subElement != null && subArrayElementValue != null) {
            streamArrayElement = subArrayElementValue.length > 1 ? IntStream.range(0, subArrayElementValue.length).mapToObj(i -> Csvson.getArrayElementList(prefix, subElement, subArrayElementValue[i].split("(?<!\\\\):"), i)) : IntStream.range(0, 1).mapToObj(i -> Csvson.getElementList(prefix, subElement, subElementValue));
            List<AbstractMap.SimpleEntry<String, String>> subElementMap = streamArrayElement.flatMap(Collection::stream).collect(Collectors.toList());
            System.out.println(subElementMap);
            return subElementMap;
        }
        if (subArrayElementValue != null) {
            return IntStream.range(0, subArrayElementValue.length).mapToObj(i -> new AbstractMap.SimpleEntry<String, String>(prefix + "[" + i + "]", subArrayElementValue[i])).collect(Collectors.toList());
        }
        AbstractMap.SimpleEntry<String, String> singleEntry = new AbstractMap.SimpleEntry<String, String>(entry.getKey(), entry.getValue());
        ArrayList<AbstractMap.SimpleEntry<String, String>> list = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        list.add(singleEntry);
        return list;
    }

    private static List<AbstractMap.SimpleEntry<String, String>> getElementList(String prefix, String[] subElement, String[] valueElement) {
        IntPredicate valueIsNotNull = i -> Csvson.indexExists(valueElement, i) && valueElement[i] != null && !valueElement[i].equalsIgnoreCase("");
        if (subElement == null) {
            return IntStream.range(0, 1).filter(valueIsNotNull).mapToObj(i -> new AbstractMap.SimpleEntry<String, String>(prefix, Csvson.removeVirtualanColonEscape(valueElement[i]))).collect(Collectors.toList());
        }
        return IntStream.range(0, subElement.length).filter(valueIsNotNull).mapToObj(i -> new AbstractMap.SimpleEntry<String, String>(prefix + "." + Csvson.removeVirtualanColonEscape(subElement[i]), Csvson.removeVirtualanColonEscape(valueElement[i]))).collect(Collectors.toList());
    }

    private static String removeVirtualanCommaEscape(String input) {
        return input.replace("\\,", ",");
    }

    private static String removeVirtualanColonEscape(String input) {
        return input.replace("\\:", ":");
    }

    private static List<AbstractMap.SimpleEntry<String, String>> getArrayElementList(String prefix, String[] subElement, String[] valueElement, int index) {
        IntPredicate valueIsNotNull = i -> Csvson.indexExists(valueElement, i) && valueElement[i] != null && !valueElement[i].equalsIgnoreCase("");
        if (subElement == null) {
            return IntStream.range(0, 1).filter(valueIsNotNull).mapToObj(i -> new AbstractMap.SimpleEntry<String, Object>(prefix + "[" + index + "]", (Csvson.indexExists(valueElement, i) ? Csvson.removeVirtualanColonEscape(valueElement[i]) : null))).collect(Collectors.toList());
        }
        return IntStream.range(0, subElement.length).filter(valueIsNotNull).mapToObj(i -> new AbstractMap.SimpleEntry<String, Object>(prefix + "[" + index + "]." + Csvson.removeVirtualanColonEscape(subElement[i]), (Csvson.indexExists(valueElement, i) ? Csvson.removeVirtualanColonEscape(valueElement[i]) : null))).collect(Collectors.toList());
    }

    private static boolean indexExists(String[] array, int index) {
        if (array != null && index >= 0 && index < array.length) {
            return array[index] != null;
        }
        return false;
    }
}

