/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.jassert;

import org.json.JSONArray;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualJSONAssert {
    private static final Logger log = LoggerFactory.getLogger(VirtualJSONAssert.class);

    public static boolean jAssertObject(JSONObject expected, JSONObject actual, JSONCompareMode mode) {
        JSONCompareResult result = JSONCompare.compareJSON((JSONObject)actual, (JSONObject)expected, (JSONCompareMode)mode);
        VirtualJSONAssert.logger(result);
        return result.passed();
    }

    public static boolean jAssertArray(JSONArray expected, JSONArray actual, JSONCompareMode mode) {
        JSONCompareResult result = JSONCompare.compareJSON((JSONArray)actual, (JSONArray)expected, (JSONCompareMode)mode);
        VirtualJSONAssert.logger(result);
        return result.passed();
    }

    private static void logger(JSONCompareResult result) {
        if (result.passed()) {
            log.info(result.getMessage());
        } else if (result.failed()) {
            log.error(result.getMessage());
        }
    }
}

