/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.mapson;

import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeHelper {
    private static final Logger log = LoggerFactory.getLogger(DataTypeHelper.class);

    private DataTypeHelper() {
    }

    public static void setObject(JSONObject jsonObject, String key, Object value) {
        String newValue;
        if (value == null) {
            jsonObject.put(key, (Object)"");
            return;
        }
        if (value instanceof String && (newValue = (String)value).indexOf(126) == 1) {
            DataTypeHelper.setObjectByType(jsonObject, key, value, newValue);
            return;
        }
        jsonObject.put(key, value);
    }

    public static void setObjectByType(JSONArray jsonArray, Object value) {
        String[] arrayValue = value.toString().split("~");
        if ("i".equals(arrayValue[0])) {
            jsonArray.put(Integer.parseInt(arrayValue[1]));
        } else if ("b".equals(arrayValue[0])) {
            jsonArray.put(Boolean.parseBoolean(arrayValue[1]));
        } else if ("d".equals(arrayValue[0])) {
            jsonArray.put(Double.parseDouble(arrayValue[1]));
        } else if ("l".equals(arrayValue[0])) {
            jsonArray.put(Long.parseLong(arrayValue[1]));
        } else if ("f".equals(arrayValue[0])) {
            jsonArray.put(Float.parseFloat(arrayValue[1]));
        } else {
            jsonArray.put((Object)value.toString());
        }
    }

    public static void setObjectByType(JSONObject jsonObject, String key, Object value, String newValue) {
        String[] arrayValue = newValue.split("~");
        if ("i".equals(arrayValue[0])) {
            jsonObject.put(key, Integer.parseInt(arrayValue[1]));
        } else if ("b".equals(arrayValue[0])) {
            jsonObject.put(key, Boolean.parseBoolean(arrayValue[1]));
        } else if ("d".equals(arrayValue[0])) {
            jsonObject.put(key, Double.parseDouble(arrayValue[1]));
        } else if ("l".equals(arrayValue[0])) {
            jsonObject.put(key, Long.parseLong(arrayValue[1]));
        } else if ("f".equals(arrayValue[0])) {
            jsonObject.put(key, Float.parseFloat(arrayValue[1]));
        } else {
            jsonObject.put(key, value);
        }
    }

    public static String getPrefixType(Object object) {
        String prefix = "";
        if (object instanceof Double) {
            prefix = "d~";
        } else if (object instanceof Integer) {
            prefix = "i~";
        } else if (object instanceof Boolean) {
            prefix = "b~";
        } else if (object instanceof Long) {
            prefix = "l~";
        } else if (object instanceof Float) {
            prefix = "f~";
        }
        return prefix;
    }
}

