/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.mapson;

import io.virtualan.mapson.DataTypeHelper;
import io.virtualan.mapson.exception.BadInputDataException;
import io.virtualan.util.Helper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapson {
    private static final Logger log = LoggerFactory.getLogger(Mapson.class);

    private Mapson() {
    }

    public static String buildMAPsonAsJson(Map<String, String> jsonPathMap) throws BadInputDataException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> mapsonEntry : jsonPathMap.entrySet()) {
            String key = mapsonEntry.getKey();
            if (key.indexOf(46) != -1) {
                Mapson.buildChildJson(params, key.split("\\."), mapsonEntry.getValue());
                continue;
            }
            if (key.contains("[") && key.contains("]")) {
                String originalKey = key.indexOf(".") == -1 ? key.substring(0, key.indexOf("[")) : key;
                params.put(originalKey, Mapson.buildObjectList(params, key, mapsonEntry.getValue()));
                continue;
            }
            params.put(key, mapsonEntry.getValue());
        }
        return Mapson.buildJsonString(params).toString();
    }

    public static JSONObject buildMAPsonAsJsonObject(Map<String, String> jsonPathMap) throws BadInputDataException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> mapsonEntry : jsonPathMap.entrySet()) {
            String key = mapsonEntry.getKey();
            if (key.indexOf(46) != -1) {
                Mapson.buildChildJson(params, key.split("\\."), mapsonEntry.getValue());
                continue;
            }
            if (key.contains("[") && key.contains("]")) {
                String originalKey = key.indexOf(".") == -1 ? key.substring(0, key.indexOf("[")) : key;
                params.put(originalKey, Mapson.buildObjectList(params, key, mapsonEntry.getValue()));
                continue;
            }
            params.put(key, mapsonEntry.getValue());
        }
        return Mapson.buildJsonString(params);
    }

    public static String buildMAPsonAsJson(Map<String, String> jsonPathMap, Map<String, String> contextObject) throws BadInputDataException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> mapsonEntry : jsonPathMap.entrySet()) {
            String key = mapsonEntry.getKey();
            if (key.indexOf(46) != -1) {
                Mapson.buildChildJson(params, key.split("\\."), Helper.getActualValue(mapsonEntry.getValue(), contextObject));
                continue;
            }
            if (key.contains("[") && key.contains("]")) {
                String elementAt = key.substring(0, key.indexOf(91));
                params.put(elementAt, Mapson.buildObjectList(params, key, Helper.getActualValue(mapsonEntry.getValue(), contextObject)));
                continue;
            }
            params.put(key, Helper.getActualValueForAll(mapsonEntry.getValue(), contextObject));
        }
        JSONObject object = Mapson.buildJsonString(params);
        if (object.optJSONArray("") != null) {
            return ((JSONArray)object.get("")).toString(2);
        }
        return object.toString(2);
    }

    public static Object getJSON(String json) {
        try {
            return new JSONObject(json);
        }
        catch (JSONException err) {
            try {
                return new JSONArray(json);
            }
            catch (Exception e) {
                log.error("invalid JSON > " + json);
                return null;
            }
        }
    }

    public static Map<String, String> buildMAPsonFromJson(String json) {
        Object object = Mapson.getJSON(json);
        LinkedHashMap<String, String> mapsonMap = new LinkedHashMap<String, String>();
        if (object != null) {
            if (object instanceof JSONArray) {
                Mapson.getJSONPath(object, "", mapsonMap);
            } else {
                Mapson.getJSONPath(object, null, mapsonMap);
            }
        }
        return mapsonMap;
    }

    private static List<Object> extractList(String key, Map<String, Object> jsonStructMap) {
        if (jsonStructMap.containsKey(key)) {
            return (List)jsonStructMap.get(key);
        }
        return new ArrayList<Object>();
    }

    private static List<Object> buildObjectList(Map<String, Object> jsonStructMap, String elementAt, Object value) {
        String elementAtArray = elementAt.substring(0, elementAt.indexOf(91));
        int index = Integer.parseInt(elementAt.substring(elementAt.indexOf(91) + 1, elementAt.indexOf(93)));
        List<Object> elementList = Mapson.extractList(elementAtArray, jsonStructMap);
        Mapson.populateList(index, elementList, value);
        return elementList;
    }

    private static JSONObject buildJsonString(Map<String, Object> jsonStructMap, Map<String, String> contextObject) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> mapEntry : jsonStructMap.entrySet()) {
            if (mapEntry.getValue() instanceof Map) {
                DataTypeHelper.setObject(jsonObject, mapEntry.getKey(), Mapson.buildJsonString((Map)mapEntry.getValue(), contextObject));
                continue;
            }
            if (mapEntry.getValue() instanceof List) {
                JSONArray array = new JSONArray();
                for (Object object : (List)mapEntry.getValue()) {
                    if (!(object instanceof Map)) continue;
                    JSONObject obj = Mapson.buildJsonString((Map)object);
                    array.put(Helper.getActualValue(obj, contextObject));
                }
                DataTypeHelper.setObject(jsonObject, mapEntry.getKey(), array);
                continue;
            }
            DataTypeHelper.setObject(jsonObject, mapEntry.getKey(), Helper.getActualValue(mapEntry.getValue(), contextObject));
        }
        return jsonObject;
    }

    public static JSONObject orderedJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            Field map = jsonObject.getClass().getDeclaredField("map");
            map.setAccessible(true);
            map.set(jsonObject, new LinkedHashMap());
            map.setAccessible(false);
        }
        catch (Exception e) {
            log.warn("Missing order of JSON Object");
        }
        return jsonObject;
    }

    private static JSONObject buildJsonString(Map<String, Object> jsonStructMap) {
        JSONObject jsonObject = Mapson.orderedJSONObject();
        for (Map.Entry<String, Object> mapEntry : jsonStructMap.entrySet()) {
            if (mapEntry.getValue() instanceof Map) {
                DataTypeHelper.setObject(jsonObject, mapEntry.getKey(), Mapson.buildJsonString((Map)mapEntry.getValue()));
                continue;
            }
            if (mapEntry.getValue() instanceof List) {
                JSONArray array = new JSONArray();
                for (Object object : (List)mapEntry.getValue()) {
                    if (object instanceof Map) {
                        JSONObject obj = Mapson.buildJsonString((Map)object);
                        array.put((Object)obj);
                        continue;
                    }
                    DataTypeHelper.setObjectByType(array, object);
                }
                DataTypeHelper.setObject(jsonObject, mapEntry.getKey(), array);
                continue;
            }
            DataTypeHelper.setObject(jsonObject, mapEntry.getKey(), mapEntry.getValue());
        }
        return jsonObject;
    }

    private static Map<String, Object> buildChildJson(Map<String, Object> jsonStructMap, String[] key, Object value) throws BadInputDataException {
        try {
            String elementAt = key[0];
            if (elementAt.contains("['") && elementAt.contains("']")) {
                String elementAtArray = elementAt.substring(0, elementAt.indexOf(91));
                String indexStr = elementAt.substring(elementAt.indexOf(91) + 1, elementAt.indexOf(93));
                elementAt = elementAtArray + "." + elementAt.substring(elementAt.indexOf(91) + 2, elementAt.indexOf(93) - 1) + elementAt.substring(elementAt.indexOf("']") + 2);
            }
            if (elementAt.contains("[") && elementAt.contains("]")) {
                Mapson.buildArrayOfObject(jsonStructMap, key, value, elementAt);
            } else {
                if (key.length == 1) {
                    jsonStructMap.put(elementAt, value);
                    return jsonStructMap;
                }
                Mapson.buildMapAsJson(jsonStructMap, key, value, elementAt);
            }
        }
        catch (Exception e) {
            throw new BadInputDataException("Bad input exception :" + Arrays.toString(key));
        }
        return jsonStructMap;
    }

    private static void buildMapAsJson(Map<String, Object> jsonStructMap, String[] key, Object value, String elementAt) throws BadInputDataException {
        Map<String, Object> obj = Mapson.extractDirectMap(jsonStructMap, elementAt);
        Mapson.populateKeyPath(key, value, obj);
        jsonStructMap.put(elementAt, obj);
    }

    private static void populateKeyPath(String[] key, Object value, Map<String, Object> obj) throws BadInputDataException {
        String[] subKey = new String[key.length - 1];
        System.arraycopy(key, 1, subKey, 0, subKey.length);
        Mapson.buildChildJson(obj, subKey, value);
    }

    private static Map<String, Object> extractDirectMap(Map<String, Object> jsonStructMap, String elementAt) {
        if (jsonStructMap.get(elementAt) != null) {
            return (Map)jsonStructMap.get(elementAt);
        }
        return new LinkedHashMap<String, Object>();
    }

    private static void buildArrayOfObject(Map<String, Object> jsonStructMap, String[] key, Object value, String elementAt) throws BadInputDataException {
        String elementAtArray = elementAt.substring(0, elementAt.indexOf(91));
        String indexStr = elementAt.substring(elementAt.indexOf(91) + 1, elementAt.indexOf(93));
        if (indexStr.length() == 0) {
            throw new BadInputDataException("Index missing for the json path :" + elementAt);
        }
        int index = Integer.parseInt(indexStr);
        List<Map<String, Object>> elementList = Mapson.extractElementList(jsonStructMap, elementAtArray);
        Map<String, Object> objListMap = Mapson.extractMap(index, elementList);
        if (key.length == 1 && objListMap.isEmpty()) {
            jsonStructMap.put(elementAt.substring(0, elementAt.indexOf("[")), Mapson.buildObjectList(jsonStructMap, key[0], value));
        } else {
            Mapson.populateKeyPath(key, value, objListMap);
            Mapson.populateList(index, elementList, objListMap);
            jsonStructMap.put(elementAtArray, elementList);
        }
    }

    private static void populateList(int index, List<Map<String, Object>> elementList, Map<String, Object> objListMap) {
        try {
            elementList.set(index, objListMap);
        }
        catch (IndexOutOfBoundsException e) {
            elementList.add(index, objListMap);
        }
    }

    private static void populateList(int index, List<Object> elementList, Object object) {
        try {
            elementList.set(index, object);
        }
        catch (IndexOutOfBoundsException e) {
            elementList.add(index, object);
        }
    }

    private static Map<String, Object> extractMap(int index, List<Map<String, Object>> elementList) {
        if (elementList.size() > index) {
            return elementList.get(index);
        }
        return new LinkedHashMap<String, Object>();
    }

    private static List<Map<String, Object>> extractElementList(Map<String, Object> jsonStructMap, String elementAtArray) {
        Object objectList;
        List<Map<String, Object>> elementList = new ArrayList<Map<String, Object>>();
        if (jsonStructMap.containsKey(elementAtArray) && (objectList = jsonStructMap.get(elementAtArray)) != null) {
            elementList = (List)objectList;
        }
        return elementList;
    }

    private static void getJSONPath(Object jsonObject, String key, Map<String, String> mapsonMap) {
        if (jsonObject instanceof JSONObject) {
            Mapson.getSubJson((JSONObject)jsonObject, key, mapsonMap);
        } else if (jsonObject instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)jsonObject;
            int index = 0;
            Mapson.getSubArrayPath(key, mapsonMap, jsonArray, index);
        }
    }

    private static void getSubJson(JSONObject jsonObject, String key, Map<String, String> mapsonMap) {
        JSONObject jsonObject1 = jsonObject;
        Iterator keys = jsonObject1.keys();
        while (keys.hasNext()) {
            String keey = (String)keys.next();
            String keeey = null;
            keeey = keey.contains(".") ? (key == null ? keey : key + "." + keey.split("\\.")[0] + "['" + keey.split("\\.")[1] + "']") : (key == null ? keey : key + "." + keey);
            Mapson.getSubPath(mapsonMap, jsonObject1, keey, keeey);
        }
    }

    private static void getSubArrayPath(String key, Map<String, String> mapsonMap, JSONArray jsonArray, int index) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object obj = jsonArray.get(i);
            if (obj instanceof JSONObject || obj instanceof JSONArray) {
                Mapson.getJSONPath(obj, key + "[" + index++ + "]", mapsonMap);
                continue;
            }
            String prefix = DataTypeHelper.getPrefixType(obj);
            mapsonMap.put(key + "[" + index++ + "]", prefix + obj);
        }
    }

    private static void getSubPath(Map<String, String> mapsonMap, JSONObject jsonObject1, String keey, String keeey) {
        if (jsonObject1.optJSONArray(keey) != null) {
            Mapson.getJSONPath(jsonObject1.optJSONArray(keey), keeey, mapsonMap);
        } else if (jsonObject1.optJSONObject(keey) != null) {
            Mapson.getJSONPath((JSONObject)jsonObject1.get(keey), keeey, mapsonMap);
        } else {
            String prefix = DataTypeHelper.getPrefixType(jsonObject1.get(keey));
            mapsonMap.put(keeey, prefix + jsonObject1.get(keey));
        }
    }
}

