/*
 * Decompiled with CFR 0.152.
 */
package io.virtualan.aop;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.virtualan.annotation.VirtualService;
import io.virtualan.aop.ServiceParamObject;
import io.virtualan.api.ApiResource;
import io.virtualan.core.VirtualServiceUtil;
import io.virtualan.core.model.MockServiceRequest;
import io.virtualan.core.util.ScriptErrorException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.xml.bind.JAXBException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Aspect
@Component
public class ApiVirtualAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiVirtualAspect.class);
    @Autowired
    HttpServletRequest request;
    @Autowired
    private ObjectMapper objectMapper;
    private VirtualServiceUtil virtualServiceUtil;

    public VirtualServiceUtil getVirtualServiceUtil() {
        return this.virtualServiceUtil;
    }

    @Autowired
    public void setVirtualServiceUtil(VirtualServiceUtil virtualServiceUtil) {
        this.virtualServiceUtil = virtualServiceUtil;
    }

    public String addQueryParamValue(Object list) {
        StringBuilder builder = new StringBuilder();
        for (Object obj : (List)list) {
            if (obj == null) continue;
            if (obj instanceof Integer) {
                builder.append(String.valueOf(obj));
            } else if (obj instanceof Double) {
                builder.append(String.valueOf(obj));
            } else if (obj instanceof Long) {
                builder.append(String.valueOf(obj));
            } else {
                builder.append(String.valueOf(obj));
            }
            builder.append(",");
        }
        if (builder.toString().endsWith(",")) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @Pointcut(value="@annotation(io.virtualan.annotation.ApiVirtual)")
    public void apiVirtualServicePointcut() {
        log.info("apiVirtualServicePointcut called");
    }

    @Around(value="apiVirtualServicePointcut()")
    public Object aroundAddAdvice(ProceedingJoinPoint thisJoinPoint) throws IOException, JAXBException, ScriptErrorException {
        MockServiceRequest mockServiceRequest = new MockServiceRequest();
        Object[] args = thisJoinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)thisJoinPoint.getStaticPart().getSignature();
        Method method = methodSignature.getMethod();
        Class<?> targetClass = thisJoinPoint.getTarget().getClass();
        AbstractMap.SimpleEntry<Boolean, Class> isVirtualan = this.isVirtualService(targetClass);
        if (isVirtualan.getKey().booleanValue()) {
            String parentPath = ApiResource.getResourceParent(isVirtualan.getValue());
            if (mockServiceRequest.getResource() == null) {
                mockServiceRequest.setResource(ApiResource.getResource(method));
            } else {
                mockServiceRequest.setResource(parentPath);
            }
            mockServiceRequest.setOperationId(method.getName());
            this.readInputParam(args, methodSignature, mockServiceRequest);
            Map<String, String> headersInfo = this.getHeadersInfo();
            mockServiceRequest.setHeaderParams(headersInfo);
        }
        return this.getVirtualServiceUtil().returnResponse(method, mockServiceRequest);
    }

    public AbstractMap.SimpleEntry<Boolean, Class> isVirtualService(Class<?> claszzz) {
        if (claszzz.isAnnotationPresent(VirtualService.class)) {
            return new AbstractMap.SimpleEntry<Boolean, Class>(true, claszzz);
        }
        for (Class<?> clazz : claszzz.getInterfaces()) {
            if (!clazz.isAnnotationPresent(VirtualService.class)) continue;
            return new AbstractMap.SimpleEntry<Boolean, Class>(true, clazz);
        }
        return new AbstractMap.SimpleEntry<Boolean, Class>(false, Object.class);
    }

    private Map<String, String> getHeadersInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = this.request.getHeader(key);
            map.put(key, value);
        }
        return map;
    }

    private void readInputParam(Object[] args, MethodSignature methodSignature, MockServiceRequest mockServiceRequest) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        HashMap<String, Class> paramMapType = new HashMap<String, Class>();
        Method method = methodSignature.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        assert (args.length == parameterAnnotations.length);
        block0: for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            if (parameterAnnotations[argIndex] == null || parameterAnnotations[argIndex].length <= 0) continue;
            String requestParamName = null;
            for (Annotation annotation : parameterAnnotations[argIndex]) {
                ServiceParamObject serviceParamObject = new ServiceParamObject();
                serviceParamObject.setAnnotation(annotation);
                serviceParamObject.setArgIndex(argIndex);
                serviceParamObject.setArgs(args);
                serviceParamObject.setMethodSignature(methodSignature);
                serviceParamObject.setMockServiceRequest(mockServiceRequest);
                serviceParamObject.setParamMap(paramMap);
                serviceParamObject.setParameters(parameters);
                serviceParamObject.setParamMapType(paramMapType);
                serviceParamObject.setRequestParamName(requestParamName);
                GetParams getParams = new GetParams(serviceParamObject).invoke();
                if (getParams.is()) continue block0;
                requestParamName = getParams.getRequestParamName();
            }
        }
        mockServiceRequest.setParams(paramMap);
        mockServiceRequest.setParameters(parameters);
        mockServiceRequest.setParamsType(paramMapType);
    }

    private class GetParams {
        private boolean myResult;
        private Object[] args;
        private MethodSignature methodSignature;
        private MockServiceRequest mockServiceRequest;
        private Map<String, String> paramMap;
        private Map<String, Object> parameters;
        private Map<String, Class> paramMapType;
        private int argIndex;
        private String requestParamName;
        private Annotation annotation;

        public GetParams(ServiceParamObject serviceParamObject) {
            this.args = serviceParamObject.getArgs();
            this.methodSignature = serviceParamObject.getMethodSignature();
            this.mockServiceRequest = serviceParamObject.getMockServiceRequest();
            this.paramMap = serviceParamObject.getParamMap();
            this.parameters = serviceParamObject.getParameters();
            this.paramMapType = serviceParamObject.getParamMapType();
            this.argIndex = serviceParamObject.getArgIndex();
            this.requestParamName = serviceParamObject.getRequestParamName();
            this.annotation = serviceParamObject.getAnnotation();
        }

        boolean is() {
            return this.myResult;
        }

        private String getParamName(Object[] args, MethodSignature methodSignature, MockServiceRequest mockServiceRequest, int argIndex, Annotation annotation) {
            if (annotation instanceof RequestParam) {
                RequestParam requestParam = (RequestParam)annotation;
                this.requestParamName = requestParam.value();
            } else if (annotation instanceof PathVariable) {
                PathVariable requestParam = (PathVariable)annotation;
                this.requestParamName = requestParam.value();
            } else if (annotation instanceof RequestBody) {
                this.getBody(methodSignature, mockServiceRequest, argIndex, args[argIndex]);
            } else if (annotation instanceof QueryParam) {
                QueryParam requestParam = (QueryParam)annotation;
                this.requestParamName = requestParam.value();
            } else if (annotation instanceof PathParam) {
                PathParam requestParam = (PathParam)annotation;
                this.requestParamName = requestParam.value();
            } else if (annotation instanceof FormParam) {
                FormParam requestParam = (FormParam)annotation;
                this.requestParamName = requestParam.value();
            } else if (annotation instanceof HeaderParam) {
                HeaderParam requestParam = (HeaderParam)annotation;
                this.requestParamName = requestParam.value();
            } else if (annotation instanceof MatrixParam) {
                MatrixParam requestParam = (MatrixParam)annotation;
                this.requestParamName = requestParam.value();
            } else if (annotation instanceof CookieParam) {
                CookieParam requestParam = (CookieParam)annotation;
                this.requestParamName = requestParam.value();
            }
            return this.requestParamName;
        }

        private void getBody(MethodSignature methodSignature, MockServiceRequest mockServiceRequest, int argIndex, Object arg) {
            try {
                mockServiceRequest.setInputObjectType(Class.forName(methodSignature.getParameterTypes()[argIndex].getName()));
                mockServiceRequest.setInput(arg);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage());
            }
            mockServiceRequest.setInput(arg);
        }

        public String getRequestParamName() {
            return this.requestParamName;
        }

        public GetParams invoke() {
            this.requestParamName = this.getParamName(this.args, this.methodSignature, this.mockServiceRequest, this.argIndex, this.annotation);
            if (this.requestParamName != null) {
                if (this.args[this.argIndex] instanceof List) {
                    this.paramMap.put(this.requestParamName, ApiVirtualAspect.this.addQueryParamValue(this.args[this.argIndex]));
                    this.parameters.put(this.requestParamName, ApiVirtualAspect.this.addQueryParamValue(this.args[this.argIndex]));
                } else {
                    this.paramMap.put(this.requestParamName, String.valueOf(this.args[this.argIndex]));
                    this.parameters.put(this.requestParamName, this.args[this.argIndex]);
                }
                if (this.args[this.argIndex] != null) {
                    this.paramMapType.put(this.requestParamName, this.args[this.argIndex].getClass());
                }
                this.myResult = true;
                return this;
            }
            this.myResult = false;
            return this;
        }
    }
}

