/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.cursor;

import com.google.common.base.Preconditions;
import io.vitess.client.cursor.FieldMap;
import io.vitess.client.cursor.Row;
import io.vitess.proto.Query;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class Cursor
implements AutoCloseable {
    private volatile FieldMap fieldMap;

    public abstract long getRowsAffected() throws SQLException;

    public abstract long getInsertId() throws SQLException;

    @Nullable
    public abstract Row next() throws SQLException;

    public abstract List<Query.Field> getFields() throws SQLException;

    public final int findColumn(String columnLabel) throws SQLException {
        Integer columnIndex = this.getFieldMap().getIndex((String)Preconditions.checkNotNull((Object)columnLabel));
        if (columnIndex == null) {
            throw new SQLDataException("column not found:" + columnLabel);
        }
        return columnIndex;
    }

    protected final FieldMap getFieldMap() throws SQLException {
        if (this.fieldMap == null) {
            this.fieldMap = new FieldMap(this.getFields());
        }
        return this.fieldMap;
    }
}

