/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.grpc;

public class RetryingInterceptorConfig {
    private static final long DISABLED = -1L;
    private final long initialBackoffMillis;
    private final long maxBackoffMillis;
    private final double backoffMultiplier;

    private RetryingInterceptorConfig(long initialBackoffMillis, long maxBackoffMillis, double backoffMultiplier) {
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.backoffMultiplier = backoffMultiplier;
    }

    public static RetryingInterceptorConfig noOpConfig() {
        return new RetryingInterceptorConfig(-1L, -1L, 0.0);
    }

    public static RetryingInterceptorConfig exponentialConfig(long initialBackoffMillis, long maxBackoffMillis, double backoffMultiplier) {
        return new RetryingInterceptorConfig(initialBackoffMillis, maxBackoffMillis, backoffMultiplier);
    }

    boolean isDisabled() {
        return this.initialBackoffMillis == -1L || this.maxBackoffMillis == -1L;
    }

    long getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    long getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }
}

