/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.grpc;

import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Objects;
import java.util.concurrent.Executor;

public class StaticAuthCredentials
extends CallCredentials {
    private static final Metadata.Key<String> USERNAME = Metadata.Key.of((String)"username", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> PASSWORD = Metadata.Key.of((String)"password", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final String username;
    private final String password;

    public StaticAuthCredentials(String username, String password) {
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
    }

    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier applier) {
        executor.execute(() -> {
            try {
                Metadata headers = new Metadata();
                headers.put(USERNAME, (Object)this.username);
                headers.put(PASSWORD, (Object)this.password);
                applier.apply(headers);
            }
            catch (Throwable exc) {
                applier.fail(Status.UNAUTHENTICATED.withCause(exc));
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

