/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import io.vitess.proto.Query;
import io.vitess.proto.Topodata;
import io.vitess.util.Constants;
import io.vitess.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class ConnectionProperties {
    private static final ArrayList<Field> PROPERTY_LIST = new ArrayList();
    private BooleanConnectionProperty blobsAreStrings = new BooleanConnectionProperty("blobsAreStrings", "Should the driver always treat BLOBs as Strings - specifically to work around dubious metadata returned by the server for GROUP BY clauses?", false);
    private BooleanConnectionProperty functionsNeverReturnBlobs = new BooleanConnectionProperty("functionsNeverReturnBlobs", "Should the driver always treat data from functions returning BLOBs as Strings - specifically to work around dubious metadata returned by the server for GROUP BY clauses?", false);
    private BooleanConnectionProperty tinyInt1isBit = new BooleanConnectionProperty("tinyInt1isBit", "Should the driver treat the datatype TINYINT(1) as the BIT type (because the server silently converts BIT -> TINYINT(1) when creating tables)?", true);
    private BooleanConnectionProperty yearIsDateType = new BooleanConnectionProperty("yearIsDateType", "Should the JDBC driver treat the MySQL type \"YEAR\" as a java.sql.Date, or as a SHORT?", true);
    private EnumConnectionProperty<Constants.ZeroDateTimeBehavior> zeroDateTimeBehavior = new EnumConnectionProperty("zeroDateTimeBehavior", "How should timestamps with format \"0000-00-00 00:00:00.0000\" be treated", Constants.ZeroDateTimeBehavior.GARBLE);
    private BooleanConnectionProperty useBlobToStoreUTF8OutsideBMP = new BooleanConnectionProperty("useBlobToStoreUTF8OutsideBMP", "Tells the driver to treat [MEDIUM/LONG]BLOB columns as [LONG]VARCHAR columns holding text encoded in UTF-8 that has characters outside the BMP (4-byte encodings), which MySQL server can't handle natively.", false);
    private StringConnectionProperty utf8OutsideBmpIncludedColumnNamePattern = new StringConnectionProperty("utf8OutsideBmpIncludedColumnNamePattern", "Used to specify exclusion rules to \"utf8OutsideBmpExcludedColumnNamePattern\". The regex must follow the patterns used for the java.util.regex package.", null, null);
    private StringConnectionProperty utf8OutsideBmpExcludedColumnNamePattern = new StringConnectionProperty("utf8OutsideBmpExcludedColumnNamePattern", "When \"useBlobToStoreUTF8OutsideBMP\" is set to \"true\", column names matching the given regex will still be treated as BLOBs unless they match the regex specified for \"utf8OutsideBmpIncludedColumnNamePattern\". The regex must follow the patterns used for the java.util.regex package.", null, null);
    private StringConnectionProperty characterEncoding = new StringConnectionProperty("characterEncoding", "If a character encoding cannot be detected, which fallback should be used when dealing with strings? (defaults is to 'autodetect')", null, null);
    private StringConnectionProperty userName = new StringConnectionProperty("userName", "query will be executed via this user", Constants.DEFAULT_USERNAME, null);
    private StringConnectionProperty target = new StringConnectionProperty("target", "Represents keyspace:shard@tabletType to be used to VTGates. keyspace, keyspace:shard, @tabletType all are optional.", "", null);
    private StringConnectionProperty keyspace = new StringConnectionProperty("keyspace", "Targeted keyspace to execute queries on", "", null);
    private StringConnectionProperty catalog = new StringConnectionProperty("dbName", "Database name in the keyspace", "", null);
    private StringConnectionProperty shard = new StringConnectionProperty("shard", "Targeted shard in a given keyspace", "", null);
    private EnumConnectionProperty<Topodata.TabletType> tabletType = new EnumConnectionProperty("tabletType", "Tablet Type to which Vitess will connect(primary, replica, rdonly)", (Enum)Constants.DEFAULT_TABLET_TYPE);
    private EnumConnectionProperty<Topodata.TabletType> oldTabletType = new EnumConnectionProperty("TABLET_TYPE", "Deprecated Tablet Type to which Vitess will connect(primary, replica, rdonly)", (Enum)Constants.DEFAULT_TABLET_TYPE);
    private EnumConnectionProperty<Constants.QueryExecuteType> executeType = new EnumConnectionProperty("executeType", "Query execution type: simple or stream", Constants.DEFAULT_EXECUTE_TYPE);
    private BooleanConnectionProperty twopcEnabled = new BooleanConnectionProperty("twopcEnabled", "Whether to enable two-phased commit, for atomic distributed commits. See http://vitess.io/user-guide/twopc/", false);
    private EnumConnectionProperty<Query.ExecuteOptions.IncludedFields> includedFields = new EnumConnectionProperty("includedFields", "What fields to return from MySQL to the Driver. Limiting the fields returned can improve performance, but ALL is required for maximum JDBC API support", (Enum)Constants.DEFAULT_INCLUDED_FIELDS);
    private EnumConnectionProperty<Query.ExecuteOptions.Workload> workload = new EnumConnectionProperty("workload", "The workload type to use when executing queries", (Enum)Query.ExecuteOptions.Workload.UNSPECIFIED);
    private BooleanConnectionProperty useAffectedRows = new BooleanConnectionProperty("useAffectedRows", "Don't set the CLIENT_FOUND_ROWS flag when connecting to the server. The vitess default (useAffectedRows=true) is the opposite of mysql-connector-j.", true);
    private BooleanConnectionProperty grpcRetriesEnabled = new BooleanConnectionProperty("grpcRetriesEnabled", "If enabled, a gRPC interceptor will ensure retries happen in the case of TRANSIENT gRPC errors.", true);
    private LongConnectionProperty grpcRetryInitialBackoffMillis = new LongConnectionProperty("grpcRetriesInitialBackoffMillis", "If grpcRetriesEnabled is set, what is the initial backoff time in milliseconds for exponential retry backoff.", 10L);
    private LongConnectionProperty grpcRetryMaxBackoffMillis = new LongConnectionProperty("grpcRetriesMaxBackoffMillis", "If grpcRetriesEnabled is set, what is the maximum backoff time in milliseconds for exponential retry backoff. After this threshold, failures will propagate.", TimeUnit.MINUTES.toMillis(2L));
    private DoubleConnectionProperty grpcRetryBackoffMultiplier = new DoubleConnectionProperty("grpcRetriesBackoffMultiplier", "If grpcRetriesEnabled is set, what multiplier should be used to increase exponential backoff on each retry.", 1.6);
    private BooleanConnectionProperty useSSL = new BooleanConnectionProperty("useSSL", "Whether this connection should use transport-layer security", false);
    private BooleanConnectionProperty refreshConnection = new BooleanConnectionProperty("refreshConnection", "When enabled, the driver will monitor for changes to the keystore and truststore files. If any are detected, SSL-enabled connections will be recreated.", false);
    private LongConnectionProperty refreshSeconds = new LongConnectionProperty("refreshSeconds", "How often in seconds the driver will monitor for changes to the keystore and truststore files, when refreshConnection is enabled.", 60L);
    private BooleanConnectionProperty refreshClosureDelayed = new BooleanConnectionProperty("refreshClosureDelayed", "When enabled, the closing of the old connections will be delayed instead of happening instantly.", false);
    private LongConnectionProperty refreshClosureDelaySeconds = new LongConnectionProperty("refreshClosureDelaySeconds", "How often in seconds the grace period before closing the old connections that had been recreated.", 300L);
    private StringConnectionProperty keyStore = new StringConnectionProperty("keyStore", "The Java .JKS keystore file to use when TLS is enabled", null, null);
    private StringConnectionProperty keyStorePassword = new StringConnectionProperty("keyStorePassword", "The password protecting the keystore file (if a password is set)", null, null);
    private StringConnectionProperty keyAlias = new StringConnectionProperty("keyAlias", "Alias under which the private key is stored in the keystore file (if not specified, then the first valid `PrivateKeyEntry` will be used)", null, null);
    private StringConnectionProperty keyPassword = new StringConnectionProperty("keyPassword", "The additional password protecting the private key entry within the keystore file (if not specified, then the logic will fallback to the keystore password and then to no password at all)", null, null);
    private StringConnectionProperty trustStore = new StringConnectionProperty("trustStore", "The Java .JKS truststore file to use when TLS is enabled", null, null);
    private StringConnectionProperty trustStorePassword = new StringConnectionProperty("trustStorePassword", "The password protecting the truststore file (if a password is set)", null, null);
    private StringConnectionProperty trustAlias = new StringConnectionProperty("trustAlias", "Alias under which the certificate chain is stored in the truststore file (if not specified, then the first valid `X509Certificate` will be used)", null, null);
    private BooleanConnectionProperty treatUtilDateAsTimestamp = new BooleanConnectionProperty("treatUtilDateAsTimestamp", "Should the driver treat java.util.Date as a TIMESTAMP for the purposes of PreparedStatement.setObject()", true);
    private LongConnectionProperty timeout = new LongConnectionProperty("timeout", "The default timeout, in millis, to use for queries, connections, and transaction commit/rollback. Query timeout can be overridden by explicitly calling setQueryTimeout", 30000L);
    private StringConnectionProperty useTracing = new StringConnectionProperty("tracing", "Pass on tracing span ids when communicating with Vitess", "off", new String[]{"off", "opentracing"});
    private Topodata.TabletType tabletTypeCache;
    private Query.ExecuteOptions.IncludedFields includedFieldsCache;
    private Query.ExecuteOptions executeOptionsCache;
    private boolean includeAllFieldsCache = true;
    private boolean twopcEnabledCache = false;
    private boolean simpleExecuteTypeCache = true;
    private String characterEncodingAsString = null;
    private String userNameCache;

    void initializeProperties(Properties props) throws SQLException {
        Properties propsCopy = (Properties)props.clone();
        for (Field propertyField : PROPERTY_LIST) {
            try {
                ConnectionProperty propToSet = (ConnectionProperty)propertyField.get(this);
                propToSet.initializeFrom(propsCopy);
            }
            catch (IllegalAccessException iae) {
                throw new SQLException("Unable to initialize driver properties due to " + iae.toString());
            }
        }
        this.postInitialization();
        this.checkConfiguredEncodingSupport();
    }

    private void postInitialization() {
        this.tabletTypeCache = this.tabletType.getValueAsEnum();
        this.includedFieldsCache = this.includedFields.getValueAsEnum();
        this.includeAllFieldsCache = this.includedFieldsCache == Query.ExecuteOptions.IncludedFields.ALL;
        this.twopcEnabledCache = this.twopcEnabled.getValueAsBoolean();
        this.simpleExecuteTypeCache = this.executeType.getValueAsEnum() == Constants.QueryExecuteType.SIMPLE;
        this.characterEncodingAsString = this.characterEncoding.getValueAsString();
        this.userNameCache = this.userName.getValueAsString();
        this.setExecuteOptions();
    }

    private void checkConfiguredEncodingSupport() throws SQLException {
        if (this.characterEncodingAsString != null) {
            try {
                String testString = "abc";
                StringUtils.getBytes(testString, this.characterEncodingAsString);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException("Unsupported character encoding: " + this.characterEncodingAsString);
            }
        }
    }

    static DriverPropertyInfo[] exposeAsDriverPropertyInfo(Properties info, int slotsToReserve) throws SQLException {
        return new ConnectionProperties().exposeAsDriverPropertyInfoInternal(info, slotsToReserve);
    }

    private DriverPropertyInfo[] exposeAsDriverPropertyInfoInternal(Properties info, int slotsToReserve) throws SQLException {
        this.initializeProperties(info);
        int numProperties = PROPERTY_LIST.size();
        int listSize = numProperties + slotsToReserve;
        DriverPropertyInfo[] driverProperties = new DriverPropertyInfo[listSize];
        for (int i = slotsToReserve; i < listSize; ++i) {
            Field propertyField = PROPERTY_LIST.get(i - slotsToReserve);
            try {
                ConnectionProperty propToExpose = (ConnectionProperty)propertyField.get(this);
                if (info != null) {
                    propToExpose.initializeFrom(info);
                }
                driverProperties[i] = propToExpose.getAsDriverPropertyInfo();
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new SQLException("Internal properties failure", iae);
            }
        }
        return driverProperties;
    }

    public boolean getBlobsAreStrings() {
        return this.blobsAreStrings.getValueAsBoolean();
    }

    public void setBlobsAreStrings(boolean blobsAreStrings) {
        this.blobsAreStrings.setValue(blobsAreStrings);
    }

    public boolean getUseBlobToStoreUTF8OutsideBMP() {
        return this.useBlobToStoreUTF8OutsideBMP.getValueAsBoolean();
    }

    public void setUseBlobToStoreUTF8OutsideBMP(boolean useBlobToStoreUTF8OutsideBMP) {
        this.useBlobToStoreUTF8OutsideBMP.setValue(useBlobToStoreUTF8OutsideBMP);
    }

    public boolean getTinyInt1isBit() {
        return this.tinyInt1isBit.getValueAsBoolean();
    }

    public void setTinyInt1isBit(boolean tinyInt1isBit) {
        this.tinyInt1isBit.setValue(tinyInt1isBit);
    }

    public boolean getFunctionsNeverReturnBlobs() {
        return this.functionsNeverReturnBlobs.getValueAsBoolean();
    }

    public void setFunctionsNeverReturnBlobs(boolean functionsNeverReturnBlobs) {
        this.functionsNeverReturnBlobs.setValue(functionsNeverReturnBlobs);
    }

    public String getUtf8OutsideBmpIncludedColumnNamePattern() {
        return this.utf8OutsideBmpIncludedColumnNamePattern.getValueAsString();
    }

    public void setUtf8OutsideBmpIncludedColumnNamePattern(String pattern) {
        this.utf8OutsideBmpIncludedColumnNamePattern.setValue(pattern);
    }

    public String getUtf8OutsideBmpExcludedColumnNamePattern() {
        return this.utf8OutsideBmpExcludedColumnNamePattern.getValueAsString();
    }

    public void setUtf8OutsideBmpExcludedColumnNamePattern(String pattern) {
        this.utf8OutsideBmpExcludedColumnNamePattern.setValue(pattern);
    }

    public Constants.ZeroDateTimeBehavior getZeroDateTimeBehavior() {
        return this.zeroDateTimeBehavior.getValueAsEnum();
    }

    public boolean getYearIsDateType() {
        return this.yearIsDateType.getValueAsBoolean();
    }

    public void setYearIsDateType(boolean yearIsDateType) {
        this.yearIsDateType.setValue(yearIsDateType);
    }

    public String getEncoding() {
        return this.characterEncodingAsString;
    }

    public void setEncoding(String encoding) {
        this.characterEncoding.setValue(encoding);
        this.characterEncodingAsString = this.characterEncoding.getValueAsString();
    }

    public Query.ExecuteOptions.IncludedFields getIncludedFields() {
        return this.includedFieldsCache;
    }

    public boolean isIncludeAllFields() {
        return this.includeAllFieldsCache;
    }

    public void setIncludedFields(Query.ExecuteOptions.IncludedFields includedFields) {
        this.includedFields.setValue(includedFields);
        this.includedFieldsCache = includedFields;
        this.includeAllFieldsCache = includedFields == Query.ExecuteOptions.IncludedFields.ALL;
        this.setExecuteOptions();
    }

    public Query.ExecuteOptions.Workload getWorkload() {
        return this.workload.getValueAsEnum();
    }

    public void setWorkload(Query.ExecuteOptions.Workload workload) {
        this.workload.setValue(workload);
        this.setExecuteOptions();
    }

    public boolean getUseAffectedRows() {
        return this.useAffectedRows.getValueAsBoolean();
    }

    public void setUseAffectedRows(boolean useAffectedRows) {
        this.useAffectedRows.setValue(useAffectedRows);
        this.setExecuteOptions();
    }

    private void setExecuteOptions() {
        this.executeOptionsCache = Query.ExecuteOptions.newBuilder().setIncludedFields(this.getIncludedFields()).setWorkload(this.getWorkload()).setClientFoundRows(!this.getUseAffectedRows()).build();
    }

    public Query.ExecuteOptions getExecuteOptions() {
        return this.executeOptionsCache;
    }

    public boolean getTwopcEnabled() {
        return this.twopcEnabledCache;
    }

    public void setTwopcEnabled(boolean twopcEnabled) {
        this.twopcEnabled.setValue(twopcEnabled);
        this.twopcEnabledCache = this.twopcEnabled.getValueAsBoolean();
    }

    public Constants.QueryExecuteType getExecuteType() {
        return this.executeType.getValueAsEnum();
    }

    public boolean isSimpleExecute() {
        return this.simpleExecuteTypeCache;
    }

    public void setExecuteType(Constants.QueryExecuteType executeType) {
        this.executeType.setValue(executeType);
        this.simpleExecuteTypeCache = this.executeType.getValueAsEnum() == Constants.QueryExecuteType.SIMPLE;
    }

    public Topodata.TabletType getTabletType() {
        return this.tabletTypeCache;
    }

    public void setTabletType(Topodata.TabletType tabletType) {
        this.tabletType.setValue(tabletType);
        this.tabletTypeCache = this.tabletType.getValueAsEnum();
    }

    public Boolean getGrpcRetriesEnabled() {
        return this.grpcRetriesEnabled.getValueAsBoolean();
    }

    public void setGrpcRetriesEnabled(Boolean grpcRetriesEnabled) {
        this.grpcRetriesEnabled.setValue(grpcRetriesEnabled);
    }

    public Long getGrpcRetryInitialBackoffMillis() {
        return this.grpcRetryInitialBackoffMillis.getValueAsLong();
    }

    public void setGrpcRetryInitialBackoffMillis(Long grpcRetryInitialBackoffMillis) {
        this.grpcRetryInitialBackoffMillis.setValue(grpcRetryInitialBackoffMillis);
    }

    public Long getGrpcRetryMaxBackoffMillis() {
        return this.grpcRetryMaxBackoffMillis.getValueAsLong();
    }

    public void setGrpcRetryMaxBackoffMillis(Long grpcRetryMaxBackoffMillis) {
        this.grpcRetryMaxBackoffMillis.setValue(grpcRetryMaxBackoffMillis);
    }

    public Double getGrpcRetryBackoffMultiplier() {
        return this.grpcRetryBackoffMultiplier.getValueAsDouble();
    }

    public void setGrpcRetryBackoffMultiplier(DoubleConnectionProperty grpcRetryBackoffMultiplier) {
        this.grpcRetryBackoffMultiplier = grpcRetryBackoffMultiplier;
    }

    public boolean getUseSSL() {
        return this.useSSL.getValueAsBoolean();
    }

    public boolean getRefreshConnection() {
        return this.refreshConnection.getValueAsBoolean();
    }

    public void setRefreshConnection(boolean refreshConnection) {
        this.refreshConnection.setValue(refreshConnection);
    }

    public long getRefreshSeconds() {
        return this.refreshSeconds.getValueAsLong();
    }

    public void setRefreshSeconds(long refreshSeconds) {
        this.refreshSeconds.setValue(refreshSeconds);
    }

    public boolean getRefreshClosureDelayed() {
        return this.refreshClosureDelayed.getValueAsBoolean();
    }

    public void setRefreshClosureDelayed(boolean refreshClosureDelayed) {
        this.refreshClosureDelayed.setValue(refreshClosureDelayed);
    }

    public long getRefreshClosureDelaySeconds() {
        return this.refreshClosureDelaySeconds.getValueAsLong();
    }

    public void setRefreshClosureDelaySeconds(long refreshClosureDelaySeconds) {
        this.refreshClosureDelaySeconds.setValue(refreshClosureDelaySeconds);
    }

    public String getKeyStore() {
        return this.keyStore.getValueAsString();
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword.getValueAsString();
    }

    public String getKeyAlias() {
        return this.keyAlias.getValueAsString();
    }

    public String getKeyPassword() {
        return this.keyPassword.getValueAsString();
    }

    public String getTrustStore() {
        return this.trustStore.getValueAsString();
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword.getValueAsString();
    }

    public String getTrustAlias() {
        return this.trustAlias.getValueAsString();
    }

    public boolean getTreatUtilDateAsTimestamp() {
        return this.treatUtilDateAsTimestamp.getValueAsBoolean();
    }

    public void setTreatUtilDateAsTimestamp(boolean treatUtilDateAsTimestamp) {
        this.treatUtilDateAsTimestamp.setValue(treatUtilDateAsTimestamp);
    }

    public long getTimeout() {
        return this.timeout.getValueAsLong();
    }

    public void setTimeout(long timeout) {
        this.timeout.setValue(timeout);
    }

    public boolean getUseTracing() {
        return this.useTracing.getValueAsString().equalsIgnoreCase("opentracing");
    }

    public String getTarget() {
        String tabletType;
        if (!StringUtils.isNullOrEmptyWithoutWS(this.target.getValueAsString())) {
            return this.target.getValueAsString();
        }
        String targetString = "";
        String keyspace = this.keyspace.getValueAsString();
        if (!StringUtils.isNullOrEmptyWithoutWS(keyspace)) {
            targetString = targetString + keyspace;
            String shard = this.shard.getValueAsString();
            if (!StringUtils.isNullOrEmptyWithoutWS(shard)) {
                targetString = targetString + ":" + shard;
            }
        }
        if (!StringUtils.isNullOrEmptyWithoutWS(tabletType = this.tabletType.getValueAsEnum().name())) {
            targetString = targetString + "@" + tabletType.toLowerCase();
        }
        return targetString;
    }

    @Deprecated
    protected String getKeyspace() {
        return this.keyspace.getValueAsString();
    }

    protected void setCatalog(String catalog) throws SQLException {
        this.catalog.setValue(catalog);
    }

    protected String getCatalog() throws SQLException {
        return this.catalog.getValueAsString();
    }

    protected String getUsername() {
        return this.userNameCache;
    }

    static {
        try {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = ConnectionProperties.class.getDeclaredFields()) {
                if (!ConnectionProperty.class.isAssignableFrom(declaredField.getType())) continue;
                PROPERTY_LIST.add(declaredField);
            }
            Collections.sort(PROPERTY_LIST, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class BooleanConnectionProperty
    extends ConnectionProperty {
        private BooleanConnectionProperty(String name, String description, Boolean defaultValue) {
            super(name, description, defaultValue);
        }

        @Override
        void initializeFrom(String extractedValue) {
            if (extractedValue != null) {
                this.setValue(extractedValue.equalsIgnoreCase("TRUE") || extractedValue.equalsIgnoreCase("YES"));
            } else {
                this.valueAsObject = this.defaultValue;
            }
        }

        public void setValue(boolean value) {
            this.valueAsObject = value;
        }

        @Override
        String[] getAllowableValues() {
            return new String[]{Boolean.toString(true), Boolean.toString(false), "yes", "no"};
        }

        boolean getValueAsBoolean() {
            return (Boolean)this.valueAsObject;
        }
    }

    private static class EnumConnectionProperty<T extends Enum<T>>
    extends ConnectionProperty {
        private final Class<T> clazz;

        private EnumConnectionProperty(String name, String description, Enum<T> defaultValue) {
            super(name, description, defaultValue);
            this.clazz = defaultValue.getDeclaringClass();
            if (!this.clazz.isEnum()) {
                throw new IllegalArgumentException("EnumConnectionProperty types should be enums");
            }
        }

        @Override
        void initializeFrom(String extractedValue) {
            if (extractedValue != null) {
                this.setValue(Enum.valueOf(this.clazz, extractedValue.toUpperCase()));
            } else {
                this.valueAsObject = this.defaultValue;
            }
        }

        public void setValue(T value) {
            this.valueAsObject = value;
        }

        @Override
        String[] getAllowableValues() {
            Enum[] enumConstants = (Enum[])this.clazz.getEnumConstants();
            String[] allowed = new String[enumConstants.length];
            for (int i = 0; i < enumConstants.length; ++i) {
                allowed[i] = enumConstants[i].toString();
            }
            return allowed;
        }

        T getValueAsEnum() {
            return (T)((Enum)this.valueAsObject);
        }
    }

    private static class StringConnectionProperty
    extends ConnectionProperty {
        private final String[] allowableValues;

        private StringConnectionProperty(String name, String description, String defaultValue, String[] allowableValuesToSet) {
            super(name, description, defaultValue);
            this.allowableValues = allowableValuesToSet;
        }

        @Override
        void initializeFrom(String extractedValue) {
            if (extractedValue != null) {
                this.setValue(extractedValue);
            } else {
                this.valueAsObject = this.defaultValue;
            }
        }

        @Override
        String[] getAllowableValues() {
            return this.allowableValues;
        }

        public void setValue(String value) {
            this.valueAsObject = value;
        }

        String getValueAsString() {
            return this.valueAsObject == null ? null : this.valueAsObject.toString();
        }
    }

    private static class LongConnectionProperty
    extends ConnectionProperty {
        private LongConnectionProperty(String name, String description, long defaultValue) {
            super(name, description, defaultValue);
        }

        @Override
        void initializeFrom(String extractedValue) {
            if (extractedValue != null) {
                this.setValue(Long.parseLong(extractedValue));
            } else {
                this.valueAsObject = this.defaultValue;
            }
        }

        @Override
        String[] getAllowableValues() {
            return null;
        }

        public void setValue(Long value) {
            this.valueAsObject = value;
        }

        Long getValueAsLong() {
            return this.valueAsObject == null ? null : (Long)this.valueAsObject;
        }
    }

    private static class DoubleConnectionProperty
    extends ConnectionProperty {
        private DoubleConnectionProperty(String name, String description, double defaultValue) {
            super(name, description, defaultValue);
        }

        @Override
        void initializeFrom(String extractedValue) {
            if (extractedValue != null) {
                this.setValue(Double.parseDouble(extractedValue));
            } else {
                this.valueAsObject = this.defaultValue;
            }
        }

        @Override
        String[] getAllowableValues() {
            return null;
        }

        public void setValue(Double value) {
            this.valueAsObject = value;
        }

        Double getValueAsDouble() {
            return this.valueAsObject == null ? null : (Double)this.valueAsObject;
        }
    }

    static abstract class ConnectionProperty {
        private final String name;
        private final boolean required = false;
        private final String description;
        final Object defaultValue;
        Object valueAsObject;

        private ConnectionProperty(String name, String description, Object defaultValue) {
            this.name = name;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        void initializeFrom(Properties extractFrom) {
            String extractedValue = extractFrom.getProperty(this.getPropertyName());
            Object[] allowable = this.getAllowableValues();
            if (allowable != null && extractedValue != null) {
                boolean found = false;
                for (String string : allowable) {
                    found |= string.equalsIgnoreCase(extractedValue);
                }
                if (!found) {
                    throw new IllegalArgumentException("Property '" + this.name + "' Value '" + extractedValue + "' not in the list of allowable values: " + Arrays.toString(allowable));
                }
            }
            extractFrom.remove(this.getPropertyName());
            this.initializeFrom(extractedValue);
        }

        abstract void initializeFrom(String var1);

        abstract String[] getAllowableValues();

        public String getPropertyName() {
            return this.name;
        }

        DriverPropertyInfo getAsDriverPropertyInfo() {
            DriverPropertyInfo dpi = new DriverPropertyInfo(this.name, null);
            dpi.choices = this.getAllowableValues();
            dpi.value = this.valueAsObject != null ? this.valueAsObject.toString() : null;
            dpi.required = this.required;
            dpi.description = this.description;
            return dpi;
        }
    }
}

