/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

public class DBProperties {
    private final String productVersion;
    private final String majorVersion;
    private final String minorVersion;
    private final int isolationLevel;
    private final boolean caseInsensitiveComparison;
    private final boolean storesLowerCaseTableName;

    public DBProperties(String productVersion, String majorVersion, String minorVersion, int isolationLevel, String lowerCaseTableNames) {
        this.productVersion = productVersion;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.isolationLevel = isolationLevel;
        this.caseInsensitiveComparison = "1".equalsIgnoreCase(lowerCaseTableNames) || "2".equalsIgnoreCase(lowerCaseTableNames);
        this.storesLowerCaseTableName = "1".equalsIgnoreCase(lowerCaseTableNames);
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean getUseCaseInsensitiveComparisons() {
        return this.caseInsensitiveComparison;
    }

    public boolean getStoresLowerCaseTableName() {
        return this.storesLowerCaseTableName;
    }
}

