/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import com.google.common.annotations.VisibleForTesting;
import io.vitess.jdbc.ConnectionProperties;
import io.vitess.proto.Query;
import io.vitess.util.MysqlDefs;
import io.vitess.util.StringUtils;
import io.vitess.util.charset.CharsetMapping;
import java.sql.SQLException;
import java.util.regex.PatternSyntaxException;

public class FieldWithMetadata {
    private final ConnectionProperties connectionProperties;
    private final Query.Field field;
    private final Query.Type vitessType;
    private final boolean isImplicitTempTable;
    private final boolean isSingleBit;
    private final int precisionAdjustFactor;
    private int javaType;
    private int colFlag;
    private String encoding;
    private String collationName;
    private int collationIndex;
    private int maxBytesPerChar;

    public FieldWithMetadata(ConnectionProperties connectionProperties, Query.Field field) throws SQLException {
        this.connectionProperties = connectionProperties;
        this.field = field;
        this.colFlag = field.getFlags();
        this.vitessType = field.getType();
        this.collationIndex = field.getCharset();
        if (!MysqlDefs.vitesstoMySqlType.containsKey(this.vitessType)) {
            if (field.getType().equals((Object)Query.Type.TUPLE)) {
                throw new SQLException("Invalid Column Type");
            }
            throw new SQLException("Unknown Column Type");
        }
        this.javaType = MysqlDefs.vitesstoMySqlType.get(this.vitessType);
        if (connectionProperties != null && connectionProperties.isIncludeAllFields()) {
            this.isImplicitTempTable = this.checkForImplicitTemporaryTable();
            if (this.javaType == 2004) {
                boolean isFromFunction = field.getOrgTable().isEmpty();
                if (connectionProperties.getBlobsAreStrings() || connectionProperties.getFunctionsNeverReturnBlobs() && isFromFunction) {
                    this.javaType = 12;
                } else if (this.collationIndex == 63) {
                    if (connectionProperties.getUseBlobToStoreUTF8OutsideBMP() && this.shouldSetupForUtf8StringInBlob()) {
                        this.javaType = this.getColumnLength() == 255 || this.getColumnLength() == 65535 ? 12 : -1;
                        this.collationIndex = 33;
                    } else if (this.getColumnLength() == 255) {
                        this.javaType = -3;
                    } else if (this.getColumnLength() == 65535 || this.getColumnLength() == 0xFFFFFF || this.getColumnLength() == Integer.MAX_VALUE) {
                        this.javaType = -4;
                    }
                } else {
                    this.javaType = -1;
                }
            }
            if (this.javaType == -6 && this.field.getColumnLength() == 1 && connectionProperties.getTinyInt1isBit()) {
                this.javaType = -7;
            }
            if (!this.isNativeNumericType() && !this.isNativeDateTimeType()) {
                boolean isBinaryEncoded;
                this.encoding = this.getEncodingForIndex(this.collationIndex);
                if ("UnicodeBig".equals(this.encoding)) {
                    this.encoding = "UTF-16";
                }
                if (this.vitessType == Query.Type.JSON) {
                    this.encoding = "UTF-8";
                }
                this.isSingleBit = this.javaType == -7 && (field.getColumnLength() == 0 || field.getColumnLength() == 1);
                boolean bl = isBinaryEncoded = this.isBinary() && this.collationIndex == 63;
                if (this.javaType == -3 && !isBinaryEncoded) {
                    this.javaType = 12;
                }
                if (this.javaType == -2 && !isBinaryEncoded) {
                    this.javaType = 1;
                }
            } else {
                this.encoding = "US-ASCII";
                this.isSingleBit = false;
            }
            if (this.isSigned()) {
                switch (this.javaType) {
                    case -7: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.precisionAdjustFactor = 0;
                        break;
                    }
                    default: {
                        this.precisionAdjustFactor = this.getDecimals() > 0 ? -2 : -1;
                        break;
                    }
                }
            } else {
                switch (this.javaType) {
                    case 2: 
                    case 3: {
                        this.precisionAdjustFactor = -1;
                        break;
                    }
                    default: {
                        this.precisionAdjustFactor = 0;
                        break;
                    }
                }
            }
        } else {
            if (this.vitessType == Query.Type.JSON) {
                this.encoding = "UTF-8";
            }
            this.isImplicitTempTable = false;
            this.isSingleBit = false;
            this.precisionAdjustFactor = 0;
        }
    }

    private boolean checkForImplicitTemporaryTable() {
        return this.field.getTable().length() > 5 && this.field.getTable().startsWith("#sql_");
    }

    private boolean isNativeNumericType() {
        switch (this.javaType) {
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private boolean isNativeDateTimeType() {
        switch (this.javaType) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    String getEncodingForIndex(int charsetIndex) {
        String javaEncoding = null;
        if (charsetIndex != -1) {
            javaEncoding = CharsetMapping.getJavaEncodingForCollationIndex(charsetIndex, this.connectionProperties.getEncoding());
        }
        if (javaEncoding == null) {
            javaEncoding = this.connectionProperties.getEncoding();
        }
        return javaEncoding;
    }

    public ConnectionProperties getConnectionProperties() throws SQLException {
        this.checkConnectionProperties();
        return this.connectionProperties;
    }

    public boolean hasConnectionProperties() {
        return this.connectionProperties != null;
    }

    private void checkConnectionProperties() throws SQLException {
        if (!this.hasConnectionProperties()) {
            throw new SQLException("Connection not available");
        }
    }

    private boolean shouldSetupForUtf8StringInBlob() throws SQLException {
        block7: {
            String includePattern = this.connectionProperties.getUtf8OutsideBmpIncludedColumnNamePattern();
            String excludePattern = this.connectionProperties.getUtf8OutsideBmpExcludedColumnNamePattern();
            if (excludePattern != null && !StringUtils.isNullOrEmptyWithoutWS(excludePattern)) {
                try {
                    if (!this.getOrgName().matches(excludePattern)) break block7;
                    if (includePattern != null && !StringUtils.isNullOrEmptyWithoutWS(includePattern)) {
                        try {
                            if (this.getOrgName().matches(includePattern)) {
                                return true;
                            }
                        }
                        catch (PatternSyntaxException pse) {
                            throw new SQLException("Illegal regex specified for \"utf8OutsideBmpIncludedColumnNamePattern\"", pse);
                        }
                    }
                    return false;
                }
                catch (PatternSyntaxException pse) {
                    throw new SQLException("Illegal regex specified for \"utf8OutsideBmpExcludedColumnNamePattern\"", pse);
                }
            }
        }
        return true;
    }

    public boolean isAutoIncrement() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        return (this.colFlag & 0x200) > 0;
    }

    public boolean isBinary() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        return (this.colFlag & 0x80) > 0;
    }

    public boolean isBlob() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        return (this.colFlag & 0x10) > 0;
    }

    public boolean isMultipleKey() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        return (this.colFlag & 8) > 0;
    }

    boolean isNotNull() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return true;
        }
        return (this.colFlag & 1) > 0;
    }

    public boolean isZeroFill() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        return (this.colFlag & 0x40) > 0;
    }

    public boolean isPrimaryKey() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        return (this.colFlag & 2) > 0;
    }

    public boolean isUniqueKey() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        return (this.colFlag & 4) > 0;
    }

    public boolean isUnsigned() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return true;
        }
        return (this.colFlag & 0x20) > 0;
    }

    public boolean isSigned() throws SQLException {
        this.checkConnectionProperties();
        return !this.isUnsigned();
    }

    boolean isOpaqueBinary() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        if (this.collationIndex == 63 && this.isBinary() && (this.vitessType == Query.Type.CHAR || this.vitessType == Query.Type.VARCHAR)) {
            return !this.isImplicitTemporaryTable();
        }
        return "binary".equalsIgnoreCase(this.getEncoding());
    }

    boolean isReadOnly() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        String orgColumnName = this.getOrgName();
        String orgTableName = this.getOrgTable();
        return orgColumnName == null || orgColumnName.length() <= 0 || orgTableName == null || orgTableName.length() <= 0;
    }

    public synchronized String getCollation() throws SQLException {
        if (!this.connectionProperties.isIncludeAllFields()) {
            return null;
        }
        if (this.collationName == null) {
            int collationIndex = this.getCollationIndex();
            try {
                this.collationName = CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME[collationIndex];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new SQLException("CollationIndex '" + collationIndex + "' out of bounds for collationName lookup, should be within 0 and " + CharsetMapping.COLLATION_INDEX_TO_COLLATION_NAME.length, ex);
            }
        }
        return this.collationName;
    }

    public synchronized int getMaxBytesPerCharacter() {
        if (!this.connectionProperties.isIncludeAllFields()) {
            return 0;
        }
        if (this.maxBytesPerChar == 0) {
            this.maxBytesPerChar = this.getMaxBytesPerChar(this.getCollationIndex(), this.getEncoding());
        }
        return this.maxBytesPerChar;
    }

    @VisibleForTesting
    int getMaxBytesPerChar(Integer charsetIndex, String javaCharsetName) {
        String charset = CharsetMapping.getMysqlCharsetNameForCollationIndex(charsetIndex);
        if (charset == null) {
            charset = CharsetMapping.getMysqlCharsetForJavaEncoding(javaCharsetName);
        }
        return CharsetMapping.getMblen(charset);
    }

    public String getName() {
        return this.field.getName();
    }

    public String getTable() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return null;
        }
        return this.field.getTable();
    }

    public String getOrgTable() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return null;
        }
        return this.field.getOrgTable();
    }

    public String getDatabase() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return null;
        }
        return this.field.getDatabase();
    }

    public String getOrgName() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return null;
        }
        return this.field.getOrgName();
    }

    public int getColumnLength() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return 0;
        }
        return this.field.getColumnLength();
    }

    public int getDecimals() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return 0;
        }
        return this.field.getDecimals();
    }

    public int getJavaType() {
        return this.javaType;
    }

    private Query.Type getVitessType() {
        return this.vitessType;
    }

    public int getVitessTypeValue() {
        return this.field.getTypeValue();
    }

    boolean isImplicitTemporaryTable() {
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        return this.isImplicitTempTable;
    }

    public String getEncoding() {
        if (!this.connectionProperties.isIncludeAllFields()) {
            return null;
        }
        return this.encoding;
    }

    public int getPrecisionAdjustFactor() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return 0;
        }
        return this.precisionAdjustFactor;
    }

    public boolean isSingleBit() throws SQLException {
        this.checkConnectionProperties();
        if (!this.connectionProperties.isIncludeAllFields()) {
            return false;
        }
        return this.isSingleBit;
    }

    private int getCollationIndex() {
        return this.collationIndex;
    }

    public String toString() {
        try {
            StringBuilder asString = new StringBuilder();
            asString.append(this.getClass().getCanonicalName());
            asString.append("[");
            asString.append("catalog=");
            asString.append(this.getDatabase());
            asString.append(",tableName=");
            asString.append(this.getTable());
            asString.append(",originalTableName=");
            asString.append(this.getOrgTable());
            asString.append(",columnName=");
            asString.append(this.getName());
            asString.append(",originalColumnName=");
            asString.append(this.getOrgName());
            asString.append(",vitessType=");
            asString.append(this.getVitessType());
            asString.append("(");
            asString.append(this.getJavaType());
            asString.append(")");
            asString.append(",flags=");
            if (this.isAutoIncrement()) {
                asString.append("AUTO_INCREMENT");
            }
            if (this.isPrimaryKey()) {
                asString.append(" PRIMARY_KEY");
            }
            if (this.isUniqueKey()) {
                asString.append(" UNIQUE_KEY");
            }
            if (this.isBinary()) {
                asString.append(" BINARY");
            }
            if (this.isBlob()) {
                asString.append(" BLOB");
            }
            if (this.isMultipleKey()) {
                asString.append(" MULTI_KEY");
            }
            if (this.isUnsigned()) {
                asString.append(" UNSIGNED");
            }
            if (this.isZeroFill()) {
                asString.append(" ZEROFILL");
            }
            asString.append(", charsetIndex=");
            asString.append(this.collationIndex);
            asString.append(", charsetName=");
            asString.append(this.encoding);
            asString.append("]");
            return asString.toString();
        }
        catch (Throwable ignored) {
            return super.toString();
        }
    }
}

