/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import io.vitess.client.Context;
import io.vitess.client.VTGateConnection;
import io.vitess.client.VTSession;
import io.vitess.jdbc.ConnectionProperties;
import io.vitess.jdbc.DBProperties;
import io.vitess.jdbc.VitessJDBCUrl;
import io.vitess.jdbc.VitessMariaDBDatabaseMetadata;
import io.vitess.jdbc.VitessMySQLDatabaseMetadata;
import io.vitess.jdbc.VitessPreparedStatement;
import io.vitess.jdbc.VitessStatement;
import io.vitess.jdbc.VitessVTGateManager;
import io.vitess.proto.Query;
import io.vitess.util.CommonUtils;
import io.vitess.util.MysqlDefs;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;

public class VitessConnection
extends ConnectionProperties
implements Connection {
    private static DatabaseMetaData databaseMetaData = null;
    private Set<Statement> openStatements = new HashSet<Statement>();
    private VitessVTGateManager.VTGateConnections vtGateConnections;
    private boolean closed = true;
    private boolean readOnly = false;
    private DBProperties dbProperties;
    private final VitessJDBCUrl vitessJDBCUrl;
    private final VTSession vtSession;

    public VitessConnection(String url, Properties connectionProperties) throws SQLException {
        try {
            this.vitessJDBCUrl = new VitessJDBCUrl(url, connectionProperties);
            this.closed = false;
            this.dbProperties = null;
            this.initializeProperties(this.vitessJDBCUrl.getProperties());
            this.vtSession = new VTSession(this.getTarget(), this.getExecuteOptions());
        }
        catch (Exception exc) {
            throw new SQLException("Connection initialization error - " + exc.getMessage(), exc);
        }
    }

    public void connect() {
        this.vtGateConnections = new VitessVTGateManager.VTGateConnections(this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return new VitessStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return new VitessPreparedStatement(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.vtSession.isAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (this.vtSession.isAutoCommit() != autoCommit) {
            if (this.isInTransaction()) {
                this.commit();
            }
            this.vtSession.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        this.checkAutoCommit("Cannot call commit when auto commit is true");
        if (this.isInTransaction()) {
            this.commitTx();
        }
    }

    private void commitTx() throws SQLException {
        this.executeCommand("commit");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        this.checkAutoCommit("Cannot call rollback when auto commit is true");
        if (this.isInTransaction()) {
            this.rollbackTx();
        }
    }

    private void rollbackTx() throws SQLException {
        this.executeCommand("rollback");
    }

    private void executeCommand(String sql) throws SQLException {
        try (Statement statement = this.createStatement();){
            statement.executeUpdate(sql);
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            try {
                if (this.isInTransaction()) {
                    this.rollback();
                }
                this.closeAllOpenStatements();
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        if (!this.metadataNullOrClosed()) {
            return databaseMetaData;
        }
        Class<VitessConnection> clazz = VitessConnection.class;
        synchronized (VitessConnection.class) {
            if (this.metadataNullOrClosed()) {
                String dbEngine = this.initializeDBProperties();
                databaseMetaData = dbEngine.equals("mariadb") ? new VitessMariaDBDatabaseMetadata(this) : new VitessMySQLDatabaseMetadata(this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return databaseMetaData;
        }
    }

    private boolean metadataNullOrClosed() throws SQLException {
        return null == databaseMetaData || null == databaseMetaData.getConnection() || databaseMetaData.getConnection().isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        if (this.isInTransaction()) {
            throw new SQLException("This method should not be called when a transaction is open");
        }
        this.readOnly = readOnly;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return super.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        super.setCatalog(catalog);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        switch (this.vtSession.getTransactionIsolation()) {
            case DEFAULT: {
                return this.getMetaData().getDefaultTransactionIsolation();
            }
            case READ_COMMITTED: {
                return 2;
            }
            case READ_UNCOMMITTED: {
                return 1;
            }
            case REPEATABLE_READ: {
                return 4;
            }
            case SERIALIZABLE: {
                return 8;
            }
        }
        throw new SQLException("This isolation level is not supported");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        Query.ExecuteOptions.TransactionIsolation isolation;
        this.checkOpen();
        if (this.isInTransaction()) {
            this.rollbackTx();
        }
        if (0 == level || !this.getMetaData().supportsTransactionIsolationLevel(level)) {
            throw new SQLException("This isolation level is not supported");
        }
        switch (level) {
            case 2: {
                isolation = Query.ExecuteOptions.TransactionIsolation.READ_COMMITTED;
                break;
            }
            case 1: {
                isolation = Query.ExecuteOptions.TransactionIsolation.READ_UNCOMMITTED;
                break;
            }
            case 4: {
                isolation = Query.ExecuteOptions.TransactionIsolation.REPEATABLE_READ;
                break;
            }
            case 8: {
                isolation = Query.ExecuteOptions.TransactionIsolation.SERIALIZABLE;
                break;
            }
            default: {
                throw new SQLException("This isolation level is not supported");
            }
        }
        this.vtSession.setTransactionIsolation(isolation);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        if (resultSetType != 1003) {
            throw new SQLException("This Result Set type is not supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("This Result Set Concurrency is not supported");
        }
        return new VitessStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        if (resultSetType != 1003) {
            throw new SQLException("This Result Set type is not supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("This Result Set Concurrency is not supported");
        }
        return new VitessPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return this.getMetaData().getResultSetHoldability();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout value cannot be negative");
        }
        return this.closed ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> errorMap = new HashMap<String, ClientInfoStatus>();
        ClientInfoStatus clientInfoStatus = ClientInfoStatus.REASON_UNKNOWN;
        errorMap.put(name, clientInfoStatus);
        throw new SQLClientInfoException("SQL Feature Not Supported", errorMap);
    }

    @Override
    public String getClientInfo(String name) {
        return null;
    }

    @Override
    public Properties getClientInfo() {
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> errorMap = new HashMap<String, ClientInfoStatus>();
        ClientInfoStatus clientInfoStatus = ClientInfoStatus.REASON_UNKNOWN;
        for (String name : properties.stringPropertyNames()) {
            errorMap.put(name, clientInfoStatus);
        }
        throw new SQLClientInfoException("SQL Feature Not Supported", errorMap);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (!this.closed) {
            if (null == executor) {
                throw new SQLException("Executor cannot be null");
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        VitessConnection.this.close();
                    }
                    catch (SQLException exc) {
                        throw new RuntimeException(exc);
                    }
                }
            });
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException ccexc) {
            throw new SQLException("Unable to unwrap to " + iface.toString(), ccexc);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkOpen();
        return iface.isInstance(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return new VitessPreparedStatement(this, sql, autoGeneratedKeys);
    }

    private void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is Closed");
        }
    }

    private void checkAutoCommit(String exception) throws SQLException {
        if (this.vtSession.isAutoCommit()) {
            throw new SQLException(exception);
        }
    }

    public boolean isInTransaction() {
        return this.vtSession.isInTransaction();
    }

    public VTGateConnection getVtGateConn() {
        return this.vtGateConnections.getVtGateConnInstance();
    }

    public VTSession getVtSession() {
        return this.vtSession;
    }

    public VitessJDBCUrl getUrl() {
        return this.vitessJDBCUrl;
    }

    public void registerStatement(Statement statement) {
        this.openStatements.add(statement);
    }

    public void unregisterStatement(Statement statement) {
        this.openStatements.remove(statement);
    }

    private void closeAllOpenStatements() throws SQLException {
        SQLException postponedException = null;
        for (Statement statement : new ArrayList<Statement>(this.openStatements)) {
            try {
                VitessStatement vitessStatement = (VitessStatement)statement;
                vitessStatement.close();
            }
            catch (SQLException sqlEx) {
                postponedException = sqlEx;
            }
        }
        this.openStatements.clear();
        if (postponedException != null) {
            throw postponedException;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Savepoint setSavepoint(String namexc) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL Feature Not Supported");
    }

    private String initializeDBProperties() throws SQLException {
        HashMap<String, String> dbVariables = new HashMap<String, String>();
        String dbEngine = null;
        if (this.metadataNullOrClosed()) {
            try (VitessStatement vitessStatement = new VitessStatement(this);
                 ResultSet resultSet = vitessStatement.executeQuery("SHOW VARIABLES WHERE VARIABLE_NAME IN ('tx_isolation','INNODB_VERSION', 'lower_case_table_names')");){
                while (resultSet.next()) {
                    dbVariables.put(resultSet.getString(1), resultSet.getString(2));
                }
                String versionValue = (String)dbVariables.get("innodb_version");
                String transactionIsolation = (String)dbVariables.get("tx_isolation");
                String lowerCaseTables = (String)dbVariables.get("lower_case_table_names");
                String productVersion = "";
                String majorVersion = "";
                String minorVersion = "";
                int isolationLevel = 0;
                if (MysqlDefs.mysqlConnectionTransactionMapping.containsKey(transactionIsolation)) {
                    isolationLevel = MysqlDefs.mysqlConnectionTransactionMapping.get(transactionIsolation);
                }
                if (null != versionValue) {
                    dbEngine = versionValue.toLowerCase().contains("mariadb") ? "mariadb" : "mysql";
                    if (versionValue.contains("-")) {
                        String[] versions = versionValue.split("-");
                        productVersion = versions[0];
                    } else {
                        productVersion = versionValue;
                    }
                    String[] dbVersions = productVersion.split("\\.", 3);
                    majorVersion = dbVersions[0];
                    minorVersion = dbVersions[1];
                }
                this.dbProperties = new DBProperties(productVersion, majorVersion, minorVersion, isolationLevel, lowerCaseTables);
            }
        }
        return dbEngine;
    }

    public DBProperties getDbProperties() {
        return this.dbProperties;
    }

    public Context createContext(long deadlineAfter) {
        return CommonUtils.createContext(this.getUsername(), deadlineAfter);
    }
}

