/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.jdbc;

import io.vitess.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VitessJDBCUrl {
    private final String url;
    private final List<HostInfo> hostInfos;
    private final Properties info;

    public VitessJDBCUrl(String url, Properties info) throws SQLException {
        String keyspace;
        Pattern p = Pattern.compile("^jdbc:(vitess)://((\\w+)(:(\\w*))?@)?([^/?]*)(/([^/?]*))?(/(\\w+))?(\\?(\\S+))?");
        Matcher m = p.matcher(url);
        if (!m.find()) {
            throw new SQLException("Malformed URL Exception");
        }
        info = VitessJDBCUrl.getURLParamProperties(m.group(12), info);
        String postUrl = m.group(6);
        if (null == postUrl) {
            throw new SQLException("Malformed URL Exception");
        }
        this.hostInfos = VitessJDBCUrl.getURLHostInfos(postUrl);
        this.url = url;
        String userName = m.group(3);
        if (!StringUtils.isNullOrEmptyWithoutWS(userName)) {
            info.setProperty("userName", userName);
        }
        if (!StringUtils.isNullOrEmptyWithoutWS(keyspace = m.group(8))) {
            info.setProperty("keyspace", keyspace);
            String catalog = m.group(10);
            if (!StringUtils.isNullOrEmptyWithoutWS(catalog)) {
                info.setProperty("dbName", catalog);
            } else {
                info.setProperty("dbName", keyspace);
            }
        }
        String oldTabletType = info.getProperty("TABLET_TYPE");
        String tabletType = info.getProperty("tabletType");
        if (null != tabletType) {
            info.setProperty("TABLET_TYPE", tabletType);
        } else if (null != oldTabletType) {
            info.setProperty("tabletType", oldTabletType);
        }
        this.info = info;
    }

    public String getUrl() {
        return this.url;
    }

    public List<HostInfo> getHostInfos() {
        return this.hostInfos;
    }

    private static Properties getURLParamProperties(String paramString, Properties info) throws SQLException {
        Properties properties = info = info == null ? new Properties() : new Properties(info);
        if (!StringUtils.isNullOrEmptyWithoutWS(paramString)) {
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreTokens()) {
                String parameterValuePair = queryParams.nextToken();
                int indexOfEquals = parameterValuePair.indexOf(61);
                String parameter = null;
                String value = null;
                if (indexOfEquals != -1) {
                    parameter = parameterValuePair.substring(0, indexOfEquals);
                    if (indexOfEquals + 1 < parameterValuePair.length()) {
                        value = parameterValuePair.substring(indexOfEquals + 1);
                    }
                }
                if (null == value || value.length() <= 0 || parameter.length() <= 0 || null != info.getProperty(parameter)) continue;
                try {
                    info.put(parameter, URLDecoder.decode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException | NoSuchMethodError badEncoding) {
                    throw new SQLException("Malformed URL Exception");
                }
            }
        }
        return info;
    }

    private static List<HostInfo> getURLHostInfos(String hostURLs) throws SQLException {
        ArrayList<HostInfo> hostInfos = new ArrayList<HostInfo>();
        StringTokenizer stringTokenizer = new StringTokenizer(hostURLs, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String hostString = stringTokenizer.nextToken();
            Pattern p = Pattern.compile("([^/:]+):(\\d+)?");
            Matcher m = p.matcher(hostString);
            if (!m.find()) {
                throw new SQLException("Malformed URL Exception");
            }
            String hostname = m.group(1);
            int port = m.group(2) != null ? Integer.parseInt(m.group(2)) : Integer.parseInt("15991");
            HostInfo hostInfo = new HostInfo(hostname, port);
            hostInfos.add(hostInfo);
        }
        if (hostInfos.size() == 0) {
            throw new SQLException("Malformed URL Exception");
        }
        return hostInfos;
    }

    public Properties getProperties() {
        return this.info;
    }

    public static class HostInfo {
        private String hostname;
        private int port;

        public HostInfo(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.hostname + ":" + this.port;
        }
    }
}

