/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.ActorFactory;
import io.vlingo.actors.Address;
import io.vlingo.actors.CompletesEventually;
import io.vlingo.actors.DeadLetters;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Environment;
import io.vlingo.actors.Evictable;
import io.vlingo.actors.LifeCycle;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Protocols;
import io.vlingo.actors.Relocatable;
import io.vlingo.actors.ResultReturns;
import io.vlingo.actors.Stage;
import io.vlingo.actors.Startable;
import io.vlingo.actors.Stoppable;
import io.vlingo.actors.Supervisor;
import io.vlingo.actors.testkit.TestContext;
import io.vlingo.actors.testkit.TestEnvironment;
import io.vlingo.actors.testkit.TestState;
import io.vlingo.actors.testkit.TestStateView;
import io.vlingo.common.Completes;
import io.vlingo.common.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public abstract class Actor
implements Startable,
Stoppable,
Relocatable,
TestStateView {
    final ResultReturns returns;
    final LifeCycle lifeCycle;

    public Address address() {
        return this.lifeCycle.address();
    }

    @Override
    public void conclude() {
        this.selfAs(Stoppable.class).stop();
    }

    public DeadLetters deadLetters() {
        return this.lifeCycle.environment.stage.world().deadLetters();
    }

    public Scheduler scheduler() {
        return this.lifeCycle.environment.stage.scheduler();
    }

    @Override
    public <S> void stateSnapshot(S stateSnapshot) {
    }

    @Override
    public <S> S stateSnapshot() {
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public boolean isStopped() {
        return this.lifeCycle.isStopped();
    }

    @Override
    public void stop() {
        if (!this.isStopped() && this.lifeCycle.address().id() != 0x7FFFFFFFFFFFFFFDL) {
            this.lifeCycle.suspendForStop();
            this.lifeCycle.stop(this);
        }
    }

    public void viewTestStateInitialization(TestContext context) {
    }

    @Override
    public TestState viewTestState() {
        return new TestState();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.address().equals(((Actor)other).lifeCycle.address());
    }

    public int hashCode() {
        return this.lifeCycle.hashCode();
    }

    public String toString() {
        return "Actor[type=" + this.getClass().getSimpleName() + " address=" + this.address() + "]";
    }

    Actor parent() {
        if (this.lifeCycle.environment.isSecured()) {
            throw new IllegalStateException("A secured actor cannot provide its parent.");
        }
        return this.lifeCycle.environment.parent;
    }

    protected Actor() {
        Environment maybeEnvironment = ActorFactory.threadLocalEnvironment.get();
        this.lifeCycle = new LifeCycle(maybeEnvironment != null ? maybeEnvironment : new TestEnvironment(), new Evictable(this));
        ActorFactory.threadLocalEnvironment.set(null);
        this.returns = new ResultReturns();
    }

    protected <R> Completes<R> answerFrom(Completes<R> eventualOutcome) {
        eventualOutcome.andFinallyConsume(value -> this.completesEventually().with(value));
        return this.completes();
    }

    protected <T> T childActorFor(Class<T> protocol, Definition definition) {
        if (definition.supervisor() != null) {
            return this.lifeCycle.environment.stage.actorFor(protocol, definition, this, definition.supervisor(), this.logger());
        }
        if (this instanceof Supervisor) {
            return this.lifeCycle.environment.stage.actorFor(protocol, definition, this, this.lifeCycle.lookUpProxy(Supervisor.class), this.logger());
        }
        return this.lifeCycle.environment.stage.actorFor(protocol, definition, this, null, this.logger());
    }

    protected Protocols childActorFor(Class<?>[] protocols, Definition definition) {
        if (definition.supervisor() != null) {
            return this.lifeCycle.environment.stage.actorFor(protocols, definition, this, definition.supervisor(), this.logger());
        }
        if (this instanceof Supervisor) {
            return this.lifeCycle.environment.stage.actorFor(protocols, definition, this, this.lifeCycle.lookUpProxy(Supervisor.class), this.logger());
        }
        return this.lifeCycle.environment.stage.actorFor(protocols, definition, this, null, this.logger());
    }

    protected <T> Completes<T> completes() {
        if (this.returns == null || this.returns.__internal__clientReturns == null || !this.returns.__internal__clientReturns.isCompletes()) {
            throw new IllegalStateException("Completes is not available for this protocol behavior; return type must be Completes<T>.");
        }
        return this.returns;
    }

    protected <T> CompletableFuture<T> completableFuture() {
        if (this.returns == null || this.returns.__internal__clientReturns == null || !this.returns.__internal__clientReturns.isCompletableFuture()) {
            throw new IllegalStateException("CompletableFuture is not available for this protocol behavior; return type must be CompletableFuture<T>.");
        }
        return this.returns.asCompletableFuture();
    }

    protected <T> Future<T> future(Callable<T> callable) {
        if (this.returns == null || this.returns.__internal__clientReturns == null || !this.returns.__internal__clientReturns.isFuture()) {
            throw new IllegalStateException("Future is not available for this protocol behavior; return type must be Future<T>.");
        }
        CompletableFuture completableFuture = (CompletableFuture)this.returns.clientReturns().asFuture();
        try {
            T outcome = callable.call();
            this.returns.__internal__outcome = outcome;
            completableFuture.complete(outcome);
        }
        catch (Exception e) {
            throw new RuntimeException("Actor method returning Future<T> failed.", e);
        }
        return completableFuture;
    }

    protected CompletesEventually completesEventually() {
        return this.lifeCycle.environment.completesEventually(this.returns);
    }

    public Definition definition() {
        return this.lifeCycle.definition();
    }

    protected Logger logger() {
        return this.lifeCycle.environment.logger;
    }

    protected <T> T parentAs(Class<T> protocol) {
        if (this.lifeCycle.environment.isSecured()) {
            throw new IllegalStateException("A secured actor cannot provide its parent.");
        }
        Actor parent = this.lifeCycle.environment.parent;
        return this.lifeCycle.environment.stage.actorProxyFor(protocol, parent, parent.lifeCycle.environment.mailbox);
    }

    protected void secure() {
        this.lifeCycle.secure();
    }

    protected <T> T selfAs(Class<T> protocol) {
        return this.lifeCycle.environment.stage.actorProxyFor(protocol, this, this.lifeCycle.environment.mailbox);
    }

    protected final Stage stage() {
        if (this.lifeCycle.environment.isSecured()) {
            throw new IllegalStateException("A secured actor cannot provide its stage.");
        }
        return this.lifeCycle.environment.stage;
    }

    protected Stage stageNamed(String name) {
        return this.lifeCycle.environment.stage.world().stageNamed(name);
    }

    protected void disperseStowedMessages() {
        this.lifeCycle.environment.mailbox.resume("#paused");
    }

    protected void stowMessages(Class<?> ... stowageOverrides) {
        this.lifeCycle.environment.mailbox.suspendExceptFor("#paused", stowageOverrides);
    }

    protected void beforeStart() {
    }

    protected void afterStop() {
    }

    protected void beforeRestart(Throwable reason) {
        this.logger().error("Default before restart recovery after: " + reason.getMessage(), reason);
        this.lifeCycle.afterStop(this);
    }

    protected void afterRestart(Throwable reason) {
        this.logger().error("Default after restart recovery after: " + reason.getMessage(), reason);
        this.lifeCycle.beforeStart(this);
    }

    protected void beforeResume(Throwable reason) {
        this.logger().error("Default before resume recovery after: " + reason.getMessage(), reason);
    }
}

