/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorLoggerAdapter;
import io.vlingo.actors.Address;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Environment;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Mailbox;
import io.vlingo.actors.Stage;
import io.vlingo.actors.Supervisor;
import java.lang.reflect.Constructor;

public class ActorFactory {
    static final ThreadLocal<Environment> threadLocalEnvironment = new ThreadLocal();

    public static Class<? extends Actor> actorClassWithProtocol(String actorClassname, Class<?> protocolClass) {
        try {
            Class<?> actorClass = Class.forName(actorClassname);
            ActorFactory.assertActorWithProtocol(actorClass, protocolClass);
            return actorClass;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The class " + actorClassname + " cannot be loaded because: " + e.getMessage(), e);
        }
    }

    public static void assertActorWithProtocol(Class<?> candidateActorClass, Class<?> protocolClass) {
        Class<?> superclass;
        for (superclass = candidateActorClass.getSuperclass(); superclass != null && superclass != Actor.class; superclass = superclass.getSuperclass()) {
        }
        if (superclass == null) {
            throw new IllegalStateException("Class must extend io.vlingo.actors.Actor: " + candidateActorClass.getName());
        }
        for (Class<?> protocolInterfaceClass : candidateActorClass.getInterfaces()) {
            if (protocolClass != protocolInterfaceClass) continue;
            return;
        }
        throw new IllegalStateException("Actor class " + candidateActorClass.getName() + "must implement: " + protocolClass.getName());
    }

    static Actor actorFor(Stage stage, Actor parent, Definition definition, Address address, Mailbox mailbox, Supervisor supervisor, Logger logger) throws Exception {
        Environment environment = new Environment(stage, address, definition, parent, mailbox, supervisor, ActorLoggerAdapter.from(definition.type(), address, logger));
        threadLocalEnvironment.set(environment);
        Actor actor = null;
        if (definition.hasInstantiator()) {
            actor = definition.instantiator().instantiate();
            actor.lifeCycle.sendStart(actor);
        } else if (definition.internalParameters().isEmpty()) {
            actor = definition.type().newInstance();
            actor.lifeCycle.sendStart(actor);
        } else {
            for (Constructor<?> ctor : definition.type().getConstructors()) {
                if (ctor.getParameterCount() == definition.internalParameters().size() && (actor = ActorFactory.start(ctor, definition, address, logger)) != null) break;
            }
        }
        if (actor == null) {
            throw new IllegalArgumentException("No constructor matches the given number of parameters.");
        }
        if (parent != null) {
            parent.lifeCycle.environment.addChild(actor);
        }
        return actor;
    }

    static Mailbox actorMailbox(Stage stage, Address address, Definition definition, MailboxWrapper wrapper) {
        String mailboxName = stage.world().mailboxNameFrom(definition.mailboxName());
        Mailbox mailbox = stage.world().assignMailbox(mailboxName, address.hashCode());
        return wrapper.wrap(address, mailbox);
    }

    static Mailbox actorMailbox(Stage stage, Address address, Definition definition) {
        return ActorFactory.actorMailbox(stage, address, definition, MailboxWrapper.Identity);
    }

    private static Actor start(Constructor<?> ctor, Definition definition, Address address, Logger logger) throws Exception {
        Actor actor = null;
        Object[] args = null;
        Throwable cause = null;
        for (int times = 1; times <= 2; ++times) {
            try {
                if (times == 1) {
                    args = definition.internalParameters().toArray();
                }
                actor = (Actor)ctor.newInstance(args);
                actor.lifeCycle.sendStart(actor);
                cause = null;
                return actor;
            }
            catch (Throwable t) {
                Throwable throwable = cause = t.getCause() == null ? t : t.getCause();
                if (times != 1) continue;
                args = ActorFactory.unfold(args);
                continue;
            }
        }
        if (cause != null) {
            logger.error("ActorFactory: failed actor creation. This is sometimes cause be the constructor parameter types not matching the types in the Definition.parameters(). Often it is caused by a failure in the actor constructor. We have attempted to uncover the root cause here, but that may not be available in some cases.\nThe root cause may be: " + cause + "\nSee stacktrace for more information. We strongly recommend reviewing your constructor for possible failures in dependencies that it creates.", cause);
            throw new InstantiationException("ActorFactory failed actor creation for: " + address);
        }
        return actor;
    }

    private static Object[] unfold(Object[] args) {
        Object[] unfolded = new Object[args.length];
        for (int idx = 0; idx < args.length; ++idx) {
            Object currentArg = args[idx];
            unfolded[idx] = currentArg.getClass().isArray() ? ((Object[])currentArg)[0] : args[idx];
        }
        return unfolded;
    }

    public static interface MailboxWrapper {
        public static final MailboxWrapper Identity = (a, m) -> m;

        public Mailbox wrap(Address var1, Mailbox var2);
    }
}

