/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

import io.vlingo.actors.Actor;
import io.vlingo.actors.Address;
import io.vlingo.actors.Logger;
import io.vlingo.actors.logging.LogEvent;

public class ActorLoggerAdapter
implements Logger {
    private final Logger logger;
    private final Address sourceActorAddress;
    private final Class<?> sourceActorType;

    public static ActorLoggerAdapter from(Class<?> sourceActorType, Logger logger) {
        return new ActorLoggerAdapter(sourceActorType, null, logger);
    }

    static ActorLoggerAdapter from(Class<? extends Actor> sourceActorType, Address sourceActorAddress, Logger logger) {
        return new ActorLoggerAdapter(sourceActorType, sourceActorAddress, logger);
    }

    private ActorLoggerAdapter(Class<?> sourceActorType, Address sourceActorAddress, Logger logger) {
        this.logger = logger;
        this.sourceActorAddress = sourceActorAddress;
        this.sourceActorType = sourceActorType;
    }

    @Override
    public String name() {
        return this.logger.name();
    }

    @Override
    public void close() {
        this.logger.close();
    }

    @Override
    public boolean isEnabled() {
        return this.logger.isEnabled();
    }

    @Override
    public void trace(String message) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).build();
        this.trace(logEvent);
    }

    @Override
    public void trace(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withArgs(args).build();
        this.trace(logEvent);
    }

    @Override
    public void trace(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withThrowable(throwable).build();
        this.trace(logEvent);
    }

    @Override
    public void debug(String message) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).build();
        this.debug(logEvent);
    }

    @Override
    public void debug(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withArgs(args).build();
        this.debug(logEvent);
    }

    @Override
    public void debug(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withThrowable(throwable).build();
        this.debug(logEvent);
    }

    @Override
    public void info(String message) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).build();
        this.info(logEvent);
    }

    @Override
    public void info(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withArgs(args).build();
        this.info(logEvent);
    }

    @Override
    public void info(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withThrowable(throwable).build();
        this.info(logEvent);
    }

    @Override
    public void warn(String message) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).build();
        this.warn(logEvent);
    }

    @Override
    public void warn(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withArgs(args).build();
        this.warn(logEvent);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withThrowable(throwable).build();
        this.warn(logEvent);
    }

    @Override
    public void error(String message) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).build();
        this.error(logEvent);
    }

    @Override
    public void error(String message, Object ... args) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withArgs(args).build();
        this.error(logEvent);
    }

    @Override
    public void error(String message, Throwable throwable) {
        LogEvent logEvent = new LogEvent.Builder(this.sourceActorType, message).withSourceActorAddress(this.sourceActorAddress).withThrowable(throwable).build();
        this.error(logEvent);
    }

    @Override
    public void trace(LogEvent logEvent) {
        this.logger.trace(logEvent);
    }

    @Override
    public void debug(LogEvent logEvent) {
        this.logger.debug(logEvent);
    }

    @Override
    public void info(LogEvent logEvent) {
        this.logger.info(logEvent);
    }

    @Override
    public void warn(LogEvent logEvent) {
        this.logger.warn(logEvent);
    }

    @Override
    public void error(LogEvent logEvent) {
        this.logger.error(logEvent);
    }
}

