/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.actors;

public final class Backoff {
    private static final long BACKOFF_CAP = 4096L;
    private static final long BACKOFF_RESET = 0L;
    private static final long BACKOFF_START = 1L;
    private long backoff;
    private final boolean fixed;

    public Backoff() {
        this.backoff = 0L;
        this.fixed = false;
    }

    public Backoff(long fixedBackoff) {
        this.backoff = fixedBackoff;
        this.fixed = true;
    }

    public void now() {
        if (!this.fixed) {
            if (this.backoff == 0L) {
                this.backoff = 1L;
            } else if (this.backoff < 4096L) {
                this.backoff *= 2L;
            }
        }
        this.yieldFor(this.backoff);
    }

    public void reset() {
        this.backoff = 0L;
    }

    private void yieldFor(long aMillis) {
        try {
            Thread.sleep(aMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

